
import { _decorator,Component, Node, Sprite, SpriteAtlas, EPhysics2DDrawFlags,PhysicsSystem2D,TiledMap,TiledTile,Contact2DType, UITransform , Vec2, TiledLayer, Vec3, BoxCollider2D,  TiledObjectGroup} from 'cc';
import { LoadConfig } from './loadConfig';
import { setting } from './config/setting';
import { operating } from './operating';
const { ccclass, property } = _decorator;


@ccclass('map')
export class map extends Component {
   
    @property({type:Node})
        private map:Node|null=null;  //节点当前挂载的地图
    @property({type:SpriteAtlas})
        private res_head:SpriteAtlas|null=null;
    @property({type:SpriteAtlas})
        private res_icon:SpriteAtlas|null=null;
    @property({type:SpriteAtlas})
        private res_ui:SpriteAtlas|null=null;
    @property({type:Node})
        private player:Node|null=null;

        private _npcNode:Node|null=null;        //Node
        private _signNode:Node|null=null;   
        private _doorNode:Node|null=null;   
        private _enevtNode:Node|null=null;  
        
        private _move:TiledLayer|null=null;   //TiledLayer
        private _fog:TiledLayer|null=null;
        private _npc:TiledObjectGroup|null=null;
        private _sign:TiledObjectGroup|null=null;
        private _door:TiledObjectGroup|null=null;
        private _enevt:TiledObjectGroup|null=null;
        private _tileMap:TiledMap|null=null;

        private _MapSize:any=null;
        private _LayerSize:any=null;
        private Pos:Vec3=new Vec3(0,0,0);
    
    onLoad() {
        this._MapSize=this.map.getComponent(UITransform);
        this._tileMap=this.map.getComponent(TiledMap);

        this._move=this._tileMap.getLayer('move');
        this._fog=this._tileMap.getLayer('fog'); 
        this._LayerSize=this._fog.getLayerSize(); 

        this._npc=this._tileMap.getObjectGroup('npc');
        this._sign=this._tileMap.getObjectGroup('sign');
        this._door=this._tileMap.getObjectGroup('door');
        this._enevt=this._tileMap.getObjectGroup('enevt');

        this._npcNode=this.map.getChildByName('npc');
        this._signNode=this.map.getChildByName('sign');
        this._doorNode=this.map.getChildByName('door');
        this._enevtNode=this.map.getChildByName('enevt');
        this.node.getChildByName('fog').active=false;

    }

    start(){
        this.LayerSprite();

        PhysicsSystem2D.instance.enable = true;
        PhysicsSystem2D.instance.debugDrawFlags=1;
        PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb|EPhysics2DDrawFlags.Pair |
           EPhysics2DDrawFlags.CenterOfMass |
           EPhysics2DDrawFlags.Joint |
           EPhysics2DDrawFlags.Shape;
           
        if (PhysicsSystem2D.instance) {
            PhysicsSystem2D.instance.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            PhysicsSystem2D.instance.on(Contact2DType.END_CONTACT, this.onEndContact, this);
        }
    }
    
    LayerSprite(){   
        var tileSize=this._tileMap.getTileSize();
        var LayeSize=this._fog.getLayerSize();

        this._fog.node.active=true;
        var tObjects = this._npc.getObjects();//可以获得对象的数量
        for( var i=0; i < tObjects.length; i++){
            var gid=tObjects[i].gid;
            var img=tObjects[i];
            var name:string;
            name='';
            if(gid == 248){
                name='map02';
            }else if(gid == 249){//杂
                name='map08';
            }else if(gid == 252){//铁
                name='map07';
            }else if(gid == 253){//武
                name='map21';
            }else if(gid == 254){//玉
                name='map09';
            }  else if(gid == 255){//酒
                name='map10';
            }  else if(gid == 261){//草
                name='map13';
            }else if(gid == 262){//毒
                name='map14';
            } else if(gid == 263){//宝
                name='map35';
            } else if(gid == 267){//药
                name='map17';
            } else if(gid == 268){//马
                name='map18';
            } else if(gid == 269){//敌
                name='map15';
            } else if(gid == 270){//BOSS
                name='map16';
            }  else if(gid == 276){//衣
                name='map20';
            }else if(gid == 277){//书
                name='map12';
            }
            var id=img.id;
            var node=this._npcNode.getChildByName('img'+id);

            if(name != ''){
                var w=this.res_ui.getSpriteFrame('res/ui_sign_'+name).width;
                var h=this.res_ui.getSpriteFrame('res/ui_sign_'+name).height;
                node.getComponent(UITransform).width=40;
                node.getComponent(UITransform).height=h/(w/40)
                node.getComponent(Sprite).spriteFrame=this.res_ui.getSpriteFrame('res/ui_sign_'+name)
            }else if(name != ''){
                node.getComponent(Sprite).spriteFrame=null;
            }

            node.addComponent(BoxCollider2D)
            node.getComponent(BoxCollider2D).tag=parseInt(id.toString());
            node.getComponent(BoxCollider2D).group=5;
            node.getComponent(BoxCollider2D).offset=new Vec2(40,40);
            node.getComponent(BoxCollider2D).size=tileSize;
            if(id == 86)
                console.log(node);
        }

        for(var i=0;i<LayeSize.width;i++) {
            for(var j=0;j<LayeSize.height;j++) {
                var gid=this._fog.getTileGIDAt(i,j);
                if(gid!=0){
                    var tile=this._fog.getTiledTileAt(i,j,true);
                    tile.node.layer=1;
                    tile.node.addComponent(BoxCollider2D)
                    tile.node.getComponent(BoxCollider2D).group=2;
                   tile.node.getComponent(BoxCollider2D).offset=new Vec2(tileSize.width/2,tileSize.height/2);
                    tile.node.getComponent(BoxCollider2D).size=tileSize;
                }
            }
        } 

        /*tObjects = this._npc.getObjects();//可以获得对象的数量
        for(var i=0;i<tObjects.length;i++) {
            const img=tObjects[i];
            var name=img.name
            var id=img.id;
            var node=this._enevtNode.getChildByName('img'+id);

            var w=this.res_ui.getSpriteFrame('res/ui_sign_'+name).width;
            var h=this.res_ui.getSpriteFrame('res/ui_sign_'+name).height;
            node.getComponent(UITransform).width=30;
            node.getComponent(UITransform).height=h/(w/30)
            node.getComponent(Sprite).spriteFrame=this.res_ui.getSpriteFrame('res/ui_sign_'+name)
        }*/
        

        tObjects = this._sign.getObjects();//可以获得对象的数量
        for(var i=0;i<tObjects.length;i++) {
            const img=tObjects[i];
            var name=img.name
            var id=img.id;
            var node=this._signNode.getChildByName('img'+id);

            var w=this.res_ui.getSpriteFrame('res/ui_sign_'+name).width;
            var h=this.res_ui.getSpriteFrame('res/ui_sign_'+name).height;
            node.getComponent(UITransform).width=30;
            node.getComponent(UITransform).height=h/(w/30)
            node.getComponent(Sprite).spriteFrame=this.res_ui.getSpriteFrame('res/ui_sign_'+name)
        }

    }


    onBeginContact(selfCollider, otherCollider, contact){
        //战争迷雾
        if(selfCollider.group == 2  && otherCollider.group == 1){
            var tiled=selfCollider.node.getComponent(TiledTile);
            tiled.grid=0;
            selfCollider.node.getComponent(BoxCollider2D).tag=1;
            this._fog.markForUpdateRenderData(true)
        }
        //npc
        console.log(selfCollider.group ,otherCollider.group)
        if(selfCollider.group == 5  && otherCollider.group == 4){
            var tag=selfCollider.node.getComponent(BoxCollider2D).tag;
            var tObject = this._npc.getObjects()[tag];

            var ts:any=this.player.getComponent('player')
            if (ts && ts.setBText) {
                ts.setBText(tObject.type);
            }
        }
    }

    onEndContact (selfCollider, otherCollider, contact) {
        
        if(selfCollider.group == 2){
            selfCollider.node.getComponent(BoxCollider2D).tag=0;
            setTimeout(()=>{var tiled:TiledTile=selfCollider.node.getComponent(TiledTile);
                if(selfCollider.node.getComponent(BoxCollider2D).tag == 0 ){
                    tiled.grid=445;
                    this._fog.markForUpdateRenderData(true)
                }
            },1000*60*2) 
        }
    }

    //Node坐标转Tiled坐标
    public getTilePos(posInPixel:Vec3):Vec3 {
        if(posInPixel.x<=0)
            posInPixel.x=1;
        else if(posInPixel.x>=3000)
            posInPixel.x=2999;

        if(posInPixel.y<=0)
            posInPixel.y=1;
        else if(posInPixel.y>=2400)
            posInPixel.y=2399

        var x = Math.floor(posInPixel.x / this._LayerSize.width);
        var y = Math.floor((this._MapSize.height - posInPixel.y) / this._LayerSize.height);
        this.Pos.x=x;
        this.Pos.y=y;
        this.Pos.z=0;
        return this.Pos;
    }
    //Tiled坐标转Node坐标
    public getNodePos(posInPixel:Vec3):Vec3 {
        var x = Math.floor((posInPixel.x * 60)+15);
        var y = Math.floor(this._MapSize.height -((posInPixel.y * 60)+50));
        
        this.Pos.x=x;
        this.Pos.y=y;
        this.Pos.z=0;
        return this.Pos;
    }
}


