
import { _decorator, Component, Node ,input,Input,KeyCode,Vec3,TiledMap, CircleCollider2D,UITransform,TiledLayer, Label, BoxCollider2D} from 'cc';
import { setting } from './config/setting';
import { map } from './map';
const { ccclass, property } = _decorator;


@ccclass('player')
export class player extends Component {
    
    @property({type:Node})
        private dig:Node|null=null;  //对话节点
    @property({type:Node})
        private explore:Node|null=null;  //探索节点

        private _move:TiledLayer|null=null;   //TiledLayer
        private _fog:TiledLayer|null=null;
        private BText='';
        private EText='';

        private sysInput:any={};
        private max_x:number=0;
        private max_y:number=0;
        private moveTile:number=0;
        private Pos:Vec3=new Vec3(0,0,0);
        private _MapSize:any=null;
        private _LayerSize:any=null;
        private _TiledSize:any=null;

        

    onLoad(){
        this._fog=this.node.parent.getComponent(TiledMap).getLayer('fog'); 
        this._move=this.node.parent.getComponent(TiledMap).getLayer('move');
        this._MapSize=this.node.parent.getComponent(UITransform);
        this._LayerSize=this._fog.getLayerSize(); 
        this._TiledSize=this._fog.getMapTileSize();

        this.Pos.x=30;
        this.Pos.y=31;
        this.Pos=this.getNodePos(this.Pos,);
        this.node.setPosition(this.Pos);
    }


    start () {
        this.max_x=setting.instance.getMapSize().width;
        this.max_y=setting.instance.getMapSize().height;

        input.on(Input.EventType.KEY_DOWN,this.onKerdown,this);
        input.on(Input.EventType.KEY_UP,this.onKerup,this);

        this.getComponent(CircleCollider2D).group=1;
        this.getComponent(BoxCollider2D).group=4;

        setting.instance.Playermove=true;
    }

    update(dt:any){
        this.moveTile+=dt;
        if(this.moveTile>0.2){
            setting.instance.Playermove = true;
        }
    }

    onDestroy(){
        input.off(Input.EventType.KEY_DOWN,this.onKerdown,this);
        input.off(Input.EventType.KEY_UP,this.onKerup,this);
    }

    

    onKerdown(e){
        if(!setting.instance.Playermove) return;

        setting.instance.Playermove = false;
        this.sysInput[e.keyCode]=1;

        this.playerMove();
    }

    onKerup(e){
        this.sysInput[e.keyCode]=0;
    }

    isMove():boolean{
        this.Pos=this.getTilePos(this.node.getPosition(this.Pos));
        var val1:number=0;
        var val2:number=0;
        if(this.sysInput[KeyCode.KEY_A] ||this.sysInput[KeyCode.ARROW_LEFT]){
            val1=this._move.getTileGIDAt(this.Pos.x,this.Pos.y);
            if(this.Pos.x-1>=0)
                val2=this._move.getTileGIDAt(this.Pos.x-1,this.Pos.y);
            if(val1 !=5 && (val2 != 3 && val2!=0)){
               // console.log('a'+val1,val2)
                return true;
            }

        }else if(this.sysInput[KeyCode.KEY_D] ||this.sysInput[KeyCode.ARROW_RIGHT]){
            val1=this._move.getTileGIDAt(this.Pos.x,this.Pos.y);
            if(this.Pos.x+1<=49)
                val2=this._move.getTileGIDAt(this.Pos.x+1,this.Pos.y);
            if(val1 !=3 && (val2 != 5 && val2!=0)){
                //console.log('d'+val1,val2)
                return true;
            }
        }

        if(this.sysInput[KeyCode.KEY_W] ||this.sysInput[KeyCode.ARROW_UP]){
            val1=this._move.getTileGIDAt(this.Pos.x,this.Pos.y);
            if(this.Pos.y-1>=0)
                val2=this._move.getTileGIDAt(this.Pos.x,this.Pos.y-1);
            if(val1 !=2 && (val2 != 4 && val2!=0)){
                //console.log('w'+val1,val2)
                return true;
            }

        }else if(this.sysInput[KeyCode.KEY_S] ||this.sysInput[KeyCode.ARROW_DOWN]){
            val1=this._move.getTileGIDAt(this.Pos.x,this.Pos.y);
            if(this.Pos.y+1<=39)
                val2=this._move.getTileGIDAt(this.Pos.x,this.Pos.y+1);
            if(val1 !=4 && (val2 != 2 && val2!=0)){
               // console.log('s'+val1,val2)
                return true;
            }
        }
        return false;
    }

    playerMove(){
        if((this.sysInput[KeyCode.KEY_A] ||this.sysInput[KeyCode.ARROW_LEFT] ) && this.isMove()){
            if(this.node.getPosition().x-60>this.max_x-this.max_x ){
                this.node.setPosition(this.node.getPosition().x-60,this.node.getPosition().y);
            }

        }else if((this.sysInput[KeyCode.KEY_D] ||this.sysInput[KeyCode.ARROW_RIGHT] )&& this.isMove()){
            if(this.node.getPosition().x+60<this.max_x){
                this.node.setPosition(this.node.getPosition().x+60,this.node.getPosition().y);
            }
        }

        if((this.sysInput[KeyCode.KEY_W] ||this.sysInput[KeyCode.ARROW_UP] )&& this.isMove()){
            
            if(this.node.getPosition().y+60<this.max_y){
                this.node.setPosition(this.node.getPosition().x,this.node.getPosition().y+60);
            }
        }else if((this.sysInput[KeyCode.KEY_S] ||this.sysInput[KeyCode.ARROW_DOWN] )&& this.isMove()){
            
            if(this.node.getPosition().y-60>this.max_y-this.max_y){
                this.node.setPosition(this.node.getPosition().x,this.node.getPosition().y-60);
            }
        }
        this.sysInput[KeyCode.KEY_A] =0;
        this.sysInput[KeyCode.KEY_D] =0;
        this.sysInput[KeyCode.KEY_W] =0;
        this.sysInput[KeyCode.KEY_S] =0;

        this.sysInput[KeyCode.ARROW_LEFT] =0;
        this.sysInput[KeyCode.ARROW_RIGHT] =0;
        this.sysInput[KeyCode.ARROW_UP] =0;
        this.sysInput[KeyCode.ARROW_DOWN] =0;
    }

    //Node坐标转Tiled坐标
    public getTilePos(posInPixel:Vec3):Vec3 {
        if(posInPixel.x<=0)
            posInPixel.x=1;
        else if(posInPixel.x>=3000)
            posInPixel.x=2999;

        if(posInPixel.y<=0)
            posInPixel.y=1;
        else if(posInPixel.y>=2400)
            posInPixel.y=2399



        var x = Math.floor(posInPixel.x / this._TiledSize.width);
        var y = Math.floor((this._MapSize.height - posInPixel.y) / this._TiledSize.height);
        this.Pos.x=x;
        this.Pos.y=y;
        this.Pos.z=0;
        return this.Pos;
    }
    //Tiled坐标转Node坐标
    public getNodePos(posInPixel:Vec3):Vec3 {
        var x = Math.floor((posInPixel.x * 60)+15);
        var y = Math.floor(this._MapSize.height -((posInPixel.y * 60)+50));
        
        this.Pos.x=x;
        this.Pos.y=y;
        this.Pos.z=0;
        return this.Pos;
    }

    //按钮文本
    private  setBText(str:string){
        this.BText =str;
        this.explore.getChildByName('Bt2').getChildByName('Label').getComponent(Label).string=str;
    }
    private getBText(){
        return this.BText;
    }

    //Label文本
    private setEText(str:string){
        this.EText =str;
    }
    private getEText(){
        return this.EText;
    }

}