
import { _decorator, Component, Node,Prefab,instantiate, Label,Sprite,SpriteFrame,find, EditBox } from 'cc';
import { uiManager } from '../uiManager';
import { LoadConfig } from '../loadConfig';
const { ccclass, property } = _decorator;

@ccclass('Itemdetail')
export class Itemdetail extends Component {

    //@property({type:Prefab})
    //private  item:Prefab|null=null;

    private thingNamr:string;

    private static _node:Node|null=null;


    static instance(parent:Node){
        if(this._node)
            return;
        else
        LoadConfig.getResource('prefab/ui/Itemdetail',(err: {}, prefab: Prefab)=>{
                    if (err) 
                    return;
                    this._node= instantiate(prefab);
                   
                    if (!parent) {
                        parent = find("Canvas") as Node;
                    }
                    parent.addChild(this._node);
                    this._node.setPosition(0, 0, 0);
                    this._node.active=false;
            })
    }

    start () {
        // [3]
    }

    static show(){
        if(this._node)
            this._node.active=true;
        //this.node.setPosition(0,400,0)
        //this.upPlayerProperty();
    }

    static hide(){
        if(this._node)
            this._node.active=false;
    }
   

    static setName(Name:string){
        if(this._node)
            this._node.getChildByName('name').getComponent(Label).string=Name;
    }

    static setImage(sprite:SpriteFrame){
        if(this._node)
            this._node.getChildByName('image').getComponent(Sprite).spriteFrame=sprite
    }

    static setIntro(Intro:string){
        if(this._node)
            this._node.getChildByName('intro').getComponent(Label).string=Intro;
    }

    static setEffect(Effect:string){
        if(this._node)
            this._node.getChildByName('effect').getComponent(Label).string=Effect
    }

    static setCount(count:string){
        if(this._node)
            this._node.getChildByName('count').getComponent(EditBox).string='1/'+count
    }

    callback(event: Event){
        Itemdetail.hide();
    }
}
