
import { _decorator, Component, Node, Label, UITransform } from 'cc';
import { LoadConfig } from '../loadConfig';
import { infoConfig } from '../config/infoconfig';
import { uiManager } from '../uiManager'
import { setting } from '../config/setting';
const { ccclass, property } = _decorator;

 
@ccclass('PlayerProperty')
export class PlayerProperty extends Component {
   
    @property({type:Label})
    private Vigor: Label|null = null;
    @property({type:Label})
    private Breath: Label|null = null;
    @property({type:Label})
    private Spirit: Label|null = null;
    @property({type:Label})
    private Hp: Label|null = null;
    @property({type:Label})
    private Mp: Label|null = null;
    @property({type:Label})
    private Ms: Label|null = null;
    @property({type:Label})
    private ATK_Vigor: Label|null = null;
    @property({type:Label})
    private ATK_Breath: Label|null = null;
    @property({type:Label})
    private ATK_Spirit: Label|null = null;
    @property({type:Label})
    private DEF_Vigor: Label|null = null;
    @property({type:Label})
    private DEF_Breath: Label|null = null;
    @property({type:Label})
    private DEF_Spirit: Label|null = null;
    @property({type:Label})
    private Power: Label|null = null;
    @property({type:Label})
    private Purity: Label|null = null;
    @property({type:Label})
    private Develop: Label|null = null;
    

    private static _Data:any={};
    onLoad(){
        this.node.getComponent(UITransform).width=500;

        PlayerProperty._Data.BasalDerivative={
            "Hp":{
                "Type":1,
                "Value":setting.Data.game['Vigor']*100,
            },
            "Mp":{
                "Type":1,
                "Value":setting.Data.game['Breath']*10,
            },
            "Ms":{
                "Type":1,
                "Value":setting.Data.game['Spirit']*10,
            },
            "Atk":{
                "Atk_Vigor":setting.Data.game['Vigor']*5*setting.Data.game['Power'],
                "Atk_Breath":setting.Data.game['Breath']*4*setting.Data.game['Purity'],
                "Atk_Spirit":setting.Data.game['Spirit']*3*setting.Data.game['Develop'],
            },
            "Def":{
                "Def_Vigor":setting.Data.game['Vigor']*2.5,
                "Def_Breath":setting.Data.game['Breath']*2,
                "Def_Spirit":setting.Data.game['Spirit']*1.5,

            }
        }
    }
    start () {
       // this.upPlayerProperty();
       
    }

    show(){
        this.node.active=true;
        this.upPlayerProperty();
    }


    upPlayerProperty(){
        this.BasalProperty('Vigor',this.Vigor);
        this.BasalProperty('Breath',this.Breath);
        this.BasalProperty('Spirit',this.Spirit);
       
        this.DerivativeProperty('Hp','Value',this.Hp);
        this.DerivativeProperty('Mp','Value',this.Mp);
        this.DerivativeProperty('Ms','Value',this.Ms);
        
        this.DerivativeProperty('Atk','Atk_Vigor',this.ATK_Vigor);
        this.DerivativeProperty('Atk','Atk_Breath',this.ATK_Breath);
        this.DerivativeProperty('Atk','Atk_Spirit',this.ATK_Spirit);
        this.DerivativeProperty('Def','Def_Vigor',this.DEF_Vigor);
        this.DerivativeProperty('Def','Def_Breath',this.DEF_Breath);
        this.DerivativeProperty('Def','Def_Spirit',this.DEF_Spirit);

        this.PropertyGrade('Power',this.Power);
        this.PropertyGrade('Purity',this.Purity);
        this.PropertyGrade('Develop',this.Develop);
    }

    BasalProperty(PropertyName:any,label:Label):void{
            label.string= Math.floor(setting.Data.game[PropertyName]).toString();
    }

    DerivativeProperty(PropertyName:any,Key:any,label:Label):void{
        var val=PlayerProperty._Data.BasalDerivative[PropertyName][Key];
        label.string=Math.floor(val).toString();
    }
    PropertyGrade(PropertyName:any,label:Label):void{
        var val=setting.Data.game[PropertyName];
            if(PropertyName === "Power")
                label.string=infoConfig.POWER_GRADE[val];
            else  if(PropertyName === "Purity")
                label.string=infoConfig.PURITY_GRADE[val];
            else  if(PropertyName === "Develop")
                label.string=infoConfig.DEVELOP_GRADE[val];
    }
    
    hide(){
        uiManager.instance.hideDialog('prefab/ui/PlayerProperty');
    }
    
    setPlayerProperty(Value:any){

    }
}
