
import { _decorator, Component, Node, Prefab, UITransform, instantiate,Vec3, Sprite, Button,EventHandler, Label,SpriteFrame} from 'cc';
import { LoadConfig } from '../loadConfig';
import { uiManager } from '../uiManager';
import { Itemdetail } from './Itemdetail';
import { setting } from '../config/setting';
const { ccclass, property } = _decorator;
 
@ccclass('Toolsconfig')
export class Toolsconfig extends Component {

    @property({type:Prefab})
    private item:Prefab|null=null;

    @property({type:Node})
    private content:Node|null=null;

    private _items:any={};
    private pos:Vec3=new Vec3();
    private NodeList:any={};

    private _node:Node|null=null;

    onLoad(){
        Itemdetail.instance(this.content.parent);

        var itemSize=this.content.getComponent(UITransform).width/6;
        var count=setting.Data['tools'].length;
        var row=Math.ceil(count/6);
        if(this.content.parent.getComponent(UITransform).height-30<row*itemSize+((row+1)*5))
            this.content.getComponent(UITransform).height=row*itemSize+((row+1)*5);
        else
            this.content.getComponent(UITransform).height=this.node.getComponent(UITransform).height-30;

        this.pos.z=0;
        var str:string;
        for(var i=0,h=this.content.getComponent(UITransform).height;i<row;i++){
            this.pos.y=h-((itemSize/2)+(i*itemSize));
            for(var j=0,w=itemSize;j<6;j++){
                if((i*6)+j==count){
                    j=6;
                    continue;
                }
                var node=instantiate(this.item);
                this.content.addChild(node);
                const clickEventHandler = new EventHandler();
                clickEventHandler.target = this.node; // 这个 node 节点是事件处理代码组件所属的节点
                clickEventHandler.component = 'Toolsconfig';// 这个是脚本类名
                clickEventHandler.handler = 'callback';
                clickEventHandler.customEventData = ((i*6)+j).toString();
                node.getComponent(Button).clickEvents.push(clickEventHandler);
                node.getChildByName('num').getComponent(Label).string=((i*6)+j).toString();
                str=setting.Data['tools'][(i*6)+j].picurl;
                str=str.substring(str.length-4,str.length);
                node.getChildByName('Label').getComponent(Label).string=str
                this.NodeList[str]=node;
                LoadConfig.getResource(setting.Data['tools'][(i*6)+j].picurl,(err:any,spriteFrame:any)=>{
                    if (err) {
                        console.error(err);
                        return;
                    }
                    console.log(spriteFrame);
                    str=spriteFrame.name;
                    str=str.substring(str.length-4,str.length);
                    this.NodeList[str].getChildByName('image').getComponent(Sprite).spriteFrame=spriteFrame;
                })
                
                
                this.pos.x=(w/2)+(j*w);
                node.setPosition(this.pos)
            }

        }
    }

    callback(event: Event,index:string){
         uiManager.instance.showDialog('Itemdetail',(script:any,node?:Node)=>{
            node.getChildByName('name').getComponent(Label).string=this.getName(index);
            node.getChildByName('image').getComponent(Sprite).spriteFrame=this.getImage(index);
            node.getChildByName('effect').getComponent(Label).string=this.getEffect(index);
            node.getChildByName('intro').getComponent(Label).string=this.getIntro(index);

        },this.content.parent);

        Itemdetail.setName(this.getName(index));
        Itemdetail.setImage(this.getImage(index));
        Itemdetail.setIntro(this.getIntro(index));
        Itemdetail.setEffect(this.getEffect(index));
        Itemdetail.setCount(this.getCount(index));
        Itemdetail.show()
    }

    getindex(index:string):string{
        var str=setting.Data['tools'][index].picurl;
        return str.substring(str.length-4,str.length);

    }
    getName(index:string):string{
        return setting.Data['tools'][index].Name;
    }

    getImage(index:string):SpriteFrame{
        return this.NodeList[this.getindex(index)].getChildByName('image').getComponent(Sprite).spriteFrame
    }

    getIntro(index:string):string{
        return setting.Data['tools'][index].intro;
    }

    getCount(index:string):string{
        return this.NodeList[this.getindex(index)].getChildByName('num').getComponent(Label).string
    }

    getEffect(index:string):string{
        return setting.Data['tools'][index]?.effect?.value; 
    }

    show(){
        Itemdetail.hide();
        this.node.active=true;
        //this.upPlayerProperty();
    }

    hide(){
        Itemdetail.hide();
        uiManager.instance.hideDialog('prefab/ui/Toolsconfig');
    }

    getthingName(){
    //var name:string=g
    }



    start () {
        // [3]
    }
}
