
import { _decorator, Component, Node, isValid, find, TERRAIN_NORTH_INDEX} from 'cc';
import { LoadConfig } from './loadConfig';
const { ccclass, property } = _decorator;


 
@ccclass('uiManager')
export class uiManager extends Component {

    private _digList: any = {}      //已经创建的ui界面
    private _digLoading: any = {}   //正在显示的ui界面
    private _currdig:string|null = null;
   
    private static _instance: uiManager;

    public static get instance() {
        if (this._instance) {
            return this._instance;
        }

        this._instance = new uiManager();
        return this._instance;
    }

    /**
     * 显示单例界面
     * @param {String} digPath 
     * @param {Function} cb 回调函数，创建完毕后回调
     */
    public showDialog(digPath: string,cb?: Function,parent?:Node) {
        if(digPath == '')
            return;
       // this.hideDialog(this._currdig);
        this._currdig=digPath;
        if(this._digLoading[digPath]){

            return;
        }

        let idxSplit = digPath.lastIndexOf('/');
        let scriptName = digPath.slice(idxSplit + 1);

        if (this._digList.hasOwnProperty(digPath)) {
            let panel = this._digList[digPath];
            if (isValid(panel)) {
                panel.parent = find("Canvas");
                panel.active = true;
                let script = panel.getComponent(scriptName);
                let script2 = panel.getComponent(scriptName.charAt(0).toUpperCase() + scriptName.slice(1));

                if (script && script.show) {
                    script.show();
                    cb && cb(script,panel);
                } else if (script2 && script2.show) {
                    script2.show();
                    cb && cb(script2,panel);
                } else {
                    throw `查找不到脚本文件${scriptName}`;
                }
                return;
            }
        }

        this._digLoading[digPath] = true;
        LoadConfig.createUI(digPath, (err: any, node: any) => {
            //判断是否有可能在显示前已经被关掉了？
            let isCloseBeforeShow = false;
            if (!this._digLoading[digPath]) {
                //已经被关掉
                isCloseBeforeShow = true;
            }

            this._digLoading[digPath] = false;
            if (err) {
                console.error(err);
                return;
            }

            this._digList[digPath] = node;

            let script: any = node.getComponent(scriptName);
            let script2: any = node.getComponent(scriptName.charAt(0).toUpperCase() + scriptName.slice(1));
            if (script && script.show) {
                script.show();
                cb && cb(script,node);
            } else if (script2 && script2.show) {
                script2.show();
                cb && cb(script2,node);
            } else {
                throw `查找不到脚本文件${scriptName}`;
            }

            if (isCloseBeforeShow) {
                //如果在显示前又被关闭，则直接触发关闭掉
                this.hideDialog(digPath);
            }
        },parent);
    }


    /**
     * 隐藏所有单例界面
     * @param {String} digPath 
     * @param {fn} callback
     */
     public hideAllDialog(callback?: Function){
        const keys: any[] = Object.keys(this._digList);
        keys.forEach(key => {
            let panel = this._digList[key];
            if (panel && isValid(panel)) {
                let ani = panel.getComponent('animationUI');
                if (ani) {
                    ani.close(() => {
                       // panel.parent = null;
                        if (callback && typeof callback === 'function') {
                            callback();
                        }
                    });
                } else {
                    panel.parent = null;
                    if (callback && typeof callback === 'function') {
                        callback();
                    }
                }
            } else if (callback && typeof callback === 'function') {
                callback();
            }
            console.log(key + ":" + key.value);
            this._digLoading[key] = false;
            });

     }

     /**
     * 隐藏单例界面
     * @param {String} digPath 
     * @param {fn} callback
     */
    public hideDialog(digPath: string, callback?: Function) {  
        if(digPath == '')
            return;
        if (this._digList.hasOwnProperty(digPath)) {
            let panel = this._digList[digPath];
            if (panel && isValid(panel)) {
                let ani = panel.getComponent('animationUI');
                if (ani) {
                    ani.close(() => {
                       // panel.parent = null;
                        if (callback && typeof callback === 'function') {
                            callback();
                        }
                    });
                } else {
                    panel.parent = null;
                    if (callback && typeof callback === 'function') {
                        callback();
                    }
                }
            } else if (callback && typeof callback === 'function') {
                callback();
            }
        }

        this._digLoading[digPath] = false;
    }

    start () {
        // [3]
    }


}
