const {ccclass, property} = cc._decorator;

@ccclass
export default class Test extends cc.Component {
    a: cc.Node = null;
    b: cc.Node = null;

    onLoad() {
        this.a = new cc.Node('a');
        this.b = new cc.Node('b');
        for(let i = 0; i < 5; i++) {
            this.tween(this.a, i);
            this.tween(this.b, i);
        }
    }

    tween(node: cc.Node, n: number) {
        cc.tween(node)
            .call(() => {
                cc.log(`${ node.name }: ${ n }`);
            }).start();
    }
}
