
import {
    IAssembler,
} from "cc";
import * as cc from "cc";
import {TextureAssembler} from "../Assemblers/TextureAssembler";
const {ccclass, property} = cc._decorator;
@ccclass
export default class TexturePlus extends cc.Sprite {
    @property(cc.Vec2)
    v1 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v2 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v3 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v4 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v5 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v6 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v8 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v9 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v10 : cc.Vec2 = cc.v2();
    @property(cc.Vec2)
    v11 : cc.Vec2 = cc.v2();
    @property(cc.CCBoolean)
    flipX : boolean = false;
    v0 : cc.Vec2 = cc.v2();
    v7 : cc.Vec2 = cc.v2(0,1);
    indices: number[] = [];

    uvList: cc.Vec2[] = [cc.v2(0,0),cc.v2(0.4,0),cc.v2(0.8,0),cc.v2(1,0),cc.v2(1,0.4),cc.v2(1,1),
        cc.v2(0.4,1),cc.v2(0,1),cc.v2(0.2,0),cc.v2(0.6,0),cc.v2(1,0.6),cc.v2(0.7,1)];
    uvList2: cc.Vec2[] = [];

    protected onLoad() {
        this.uvList2 = [this.v0,this.v1,this.v2,this.v3,this.v4,this.v5,this.v6,this.v7,this.v8,this.v9,this.v10,this.v11];
        for(let i = 0;i < this.uvList2.length;++i){
            this.uvList2[i].set(this.uvList[i]);
        }
    }


    _assembler: IAssembler = null!;

    protected _flushAssembler () {
        // macro.UI_GPU_DRIVEN
        const assembler = TextureAssembler;

        if (this._assembler !== assembler) {
            this.destroyRenderData();
            this._assembler = assembler;
        }

        if (!this._renderData) {
            this.updateRenderData();
        }
    }

    public UpdateVerticies() {
        this.indices.length = 0;
        //  Right bottom triangle
        this.uvList2 = [this.v0,this.v1,this.v2,this.v3,this.v4,this.v5,this.v6,this.v7,this.v8,this.v9,this.v10,this.v11];
        this.AddTriangle(2, this.v2, 4, this.v4, 3, this.v3);
        //  Left top triangle
        this.AddTriangle(0, this.v0, 7, this.v7, 6, this.v6);
        this.AddQuad(9, this.v9, 10, this.v10, 4, this.v4, 2, this.v2);
        this.AddQuad(1, this.v1, 5, this.v5, 10, this.v10, 9, this.v9);
        this.AddQuad(8, this.v8, 11, this.v11, 5, this.v5, 1, this.v1);
        this.AddQuad(0, this.v0, 6, this.v6, 11, this.v11, 8, this.v8);
        if(this._assembler && this.renderData){
            this._assembler.updateVertexData(this);
        }

    }

    protected lateUpdate(dt: number) {
        this.UpdateVerticies();
    }

    private AddTriangle(textureIndex0: number, pos0: cc.Vec2, textureIndex1: number, pos1: cc.Vec2, textureIndex2: number, pos2: cc.Vec2) {
        this.indices.push(textureIndex0);
        if (!this.flipX) {
            this.indices.push(textureIndex1);
            this.indices.push(textureIndex2);
        }
        else {
            this.indices.push(textureIndex2);
            this.indices.push(textureIndex1);
        }

    }

    private AddQuad(textureIndex0: number, pos0: cc.Vec2, textureIndex1: number, pos1: cc.Vec2, textureIndex2: number, pos2: cc.Vec2, textureIndex3: number, pos3: cc.Vec2) {
        let v0 = textureIndex0;
        let v1 = textureIndex1;
        let v2 = textureIndex2;
        let v3 = textureIndex3;
        this.indices.push(v0);
        if (!this.flipX) {
            this.indices.push(v1);
            this.indices.push(v2);
        }
        else {
            this.indices.push(v2);
            this.indices.push(v1);
        }

        this.indices.push(v0);
        if (!this.flipX) {
            this.indices.push(v2);
            this.indices.push(v3);
        }
        else {
            this.indices.push(v3);
            this.indices.push(v2);
        }

    }

    updateRenderData(){
        this.UpdateVerticies();
        if (this._assembler && this._assembler.createData) {
            this._renderData = this._assembler.createData(this);
            this._renderData!.material = this.customMaterial;
            this.markForUpdateRenderData();
            if (this.spriteFrame) {
                this._assembler.updateUVs(this);
            }
            this._updateColor();
        }
    }

}