System.register(["__unresolved_0", "cc"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, dynamicAtlasManager, Vec3, _crd, vec3_temps, i, floatsPerVert, TextureAssembler;

  function _reportPossibleCrUseOfTexturePlus(extras) {
    _reporterNs.report("TexturePlus", "../Components/TexturePlus", _context.meta, extras);
  }

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      dynamicAtlasManager = _cc.dynamicAtlasManager;
      Vec3 = _cc.Vec3;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "f7268YWs+xHNJBIX/VMUUEf", "TextureAssembler", undefined);

      __checkObsolete__(['dynamicAtlasManager', 'IAssembler', 'IRenderData', 'RenderData', 'sp', 'Sprite', 'Vec2', 'Vec3']);

      vec3_temps = [];

      for (i = 0; i < 4; i++) {
        vec3_temps.push(new Vec3());
      }
      /**
       * simple 组装器
       * 可通过 `UI.simple` 获取该组装器。
       */


      floatsPerVert = 9;

      _export("TextureAssembler", TextureAssembler = {
        createData(sprite) {
          const renderData = sprite.requestRenderData();
          let points = sprite.uvList;
          if (!points || points.length < 3) return;
          renderData.dataLength = points.length;
          let indicesCount = sprite.indices.length;
          renderData.resize(points.length, indicesCount); // @ts-ignore

          renderData.chunk.setIndexBuffer(sprite.indices);
          return renderData;
        },

        updateRenderData(sprite) {
          const frame = sprite.spriteFrame;
          dynamicAtlasManager.packToDynamicAtlas(sprite, frame);
          this.updateUVs(sprite); // dirty need
          //this.updateColor(sprite);// dirty need

          const renderData = sprite.renderData;

          if (renderData && frame) {
            if (renderData.vertDirty) {
              this.updateVertexData(sprite);
            }

            renderData.updateRenderData(sprite, frame);
          }
        },

        updateWorldVerts(sprite, chunk) {
          const renderData = sprite.renderData;
          const vData = chunk.vb;
          const dataList = renderData.data;
          const node = sprite.node;
          const matrix = node.worldMatrix;
          const stride = renderData.floatStride;
          const vec3_temp = vec3_temps[0];
          let offset = 0;

          for (let i = 0; i < dataList.length; i++) {
            const curData = dataList[i];
            Vec3.set(vec3_temp, curData.x, curData.y, 0);
            Vec3.transformMat4(vec3_temp, vec3_temp, matrix);
            offset = i * stride;
            vData[offset++] = vec3_temp.x;
            vData[offset++] = vec3_temp.y;
            vData[offset++] = vec3_temp.z;
          }
        },

        fillBuffers(sprite, renderer) {
          if (sprite === null) {
            return;
          }

          const renderData = sprite.renderData;
          const chunk = renderData.chunk;

          if (sprite.node.hasChangedFlags || renderData.vertDirty) {
            // const vb = chunk.vertexAccessor.getVertexBuffer(chunk.bufferId);
            this.updateWorldVerts(sprite, chunk);
            renderData.vertDirty = false;
          }

          const bid = chunk.bufferId;
          const vidOrigin = chunk.vertexOffset; // @ts-ignore

          const meshBuffer = chunk.meshBuffer; // @ts-ignore

          const ib = chunk.meshBuffer.iData;
          let indexOffset = meshBuffer.indexOffset;
          let vid = vidOrigin;
          const iData = sprite.indices;

          for (let i = 0, l = iData.length; i < l; i++) {
            ib[indexOffset++] = vid + iData[i];
          }

          meshBuffer.indexOffset += iData.length;
        },

        updateVertexData(sprite) {
          const renderData = sprite.renderData;

          if (!renderData) {
            return;
          }

          const uiTrans = sprite.node._uiProps.uiTransformComp;
          const dataList = renderData.data;
          const cw = uiTrans.width;
          const ch = uiTrans.height;
          const appX = uiTrans.anchorX * cw;
          const appY = uiTrans.anchorY * ch;
          let l = 0;
          let b = 0;
          let r = 0;
          let t = 0;

          if (sprite.trim) {
            l = -appX;
            b = -appY;
            r = cw - appX;
            t = ch - appY;
          } else {
            const frame = sprite.spriteFrame;
            const originSize = frame.originalSize;
            const ow = originSize.width;
            const oh = originSize.height;
            const scaleX = cw / ow;
            const scaleY = ch / oh; // @ts-ignore

            const trimmedBorder = frame.trimmedBorder;
            l = trimmedBorder.x * scaleX - appX;
            b = trimmedBorder.z * scaleY - appY;
            r = cw + trimmedBorder.y * scaleX - appX;
            t = ch + trimmedBorder.w * scaleY - appY;
          }

          let startX = l;
          let startY = b;
          let subX = r - l;
          let subY = t - b;

          for (let i = 0; i < sprite.uvList2.length; ++i) {
            let pos = sprite.uvList2[i];
            let x = sprite.flipX ? 1 - pos.x : pos.x;
            dataList[i].x = x * subX + startX;
            dataList[i].y = pos.y * subY + startY;
          }

          renderData.vertDirty = true;
        },

        updateUVs(sprite) {
          if (!sprite.spriteFrame) return;
          const renderData = sprite.renderData;
          const vData = renderData.chunk.vb;
          const uv = sprite.spriteFrame.uv;
          let polygon = sprite.uvList;
          let startX = uv[0];
          let startY = uv[1];
          let subX = uv[6] - startX;
          let subY = uv[7] - startY;
          let uvOffset = 3;

          for (let i = 0; i < polygon.length; i++) {
            let pos = polygon[i];
            let rx = sprite.flipX ? 1 - pos.x : pos.x;
            let dstOffset = floatsPerVert * i + uvOffset;
            vData[dstOffset] = startX + rx * subX;
            vData[dstOffset + 1] = startY + pos.y * subY;
          }
        },

        updateColor(sprite) {
          const renderData = sprite.renderData;
          const vData = renderData.chunk.vb;
          let colorOffset = 5;
          const color = sprite.color;
          const colorR = color.r / 255;
          const colorG = color.g / 255;
          const colorB = color.b / 255;
          const colorA = sprite.node._uiProps.opacity;

          for (let i = 0; i < sprite.uvList.length; i++, colorOffset += renderData.floatStride) {
            vData[colorOffset] = colorR;
            vData[colorOffset + 1] = colorG;
            vData[colorOffset + 2] = colorB;
            vData[colorOffset + 3] = colorA;
          }
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=29b65705cdfe92f763c7ca68c6c35e31e1422823.js.map