System.register(["cc", "cc/env"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _cc, JSB, _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _crd, cc, ccclass, property, ZombiepediaPanel;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc2) {
      _cclegacy = _cc2.cclegacy;
      __checkObsolete__ = _cc2.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc2.__checkObsoleteInNamespace__;
      _cc = _cc2;
    }, function (_ccEnv) {
      JSB = _ccEnv.JSB;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "1523di2Dr9J6bCEYClqQ08S", "ZombiepediaPanel", undefined);

      cc = __checkObsoleteInNamespace__(_cc);
      ({
        ccclass,
        property
      } = cc._decorator);

      _export("default", ZombiepediaPanel = (_dec = ccclass("ZombiepediaPanel"), _dec2 = property([cc.Animation]), _dec3 = property(cc.Camera), _dec4 = property(cc.Node), _dec5 = property(cc.Node), _dec6 = property(cc.Node), _dec(_class = (_class2 = class ZombiepediaPanel extends cc.Component {
        constructor(...args) {
          super(...args);

          _initializerDefineProperty(this, "pageList", _descriptor, this);

          _initializerDefineProperty(this, "pageCamera", _descriptor2, this);

          this.sumPage = 20;
          this.dataList = [1, 2, 3, 4, 5, 6, 7, 8, 9];
          this.curPage = 1;

          _initializerDefineProperty(this, "firstPageNode", _descriptor3, this);

          _initializerDefineProperty(this, "pageNumNode", _descriptor4, this);

          _initializerDefineProperty(this, "blockNode", _descriptor5, this);

          this.leftStartX = 0;
          this.rightStartX = 0;
          this.renderTextureList = [];
          this.progress = 0;
          this.beCreatePageList = [];
        }

        createRenderTexture() {
          let list = this.pageList;

          for (let i = 0; i < 6; ++i) {
            let renderTexture = new cc.RenderTexture();
            renderTexture.initialize({
              width: 190,
              height: 256
            }); // @ts-ignore

            renderTexture.setFilters(cc.gfx.Filter.POINT, cc.gfx.Filter.POINT);
            let spriteFrame = new cc.SpriteFrame();
            spriteFrame.texture = renderTexture;
            list[i].getComponent(cc.Sprite).spriteFrame = spriteFrame;
          }
        }

        destroyRenderTexture() {
          let list = this.pageList;

          for (let i = 0; i < list.length; ++i) {
            let comp = list[i].getComponent(cc.Sprite);

            if (comp.spriteFrame) {
              comp.spriteFrame.texture.destroy();
              comp.spriteFrame.destroy();
              comp.spriteFrame = null;
            }
          }
        }

        onLoad() {
          this.show({});
        }

        async show(extData) {
          this.sumPage = this.dataList.length + 2;

          if (this.sumPage % 2 == 1) {
            this.sumPage++;
          }

          this.pageList[0].node.on(cc.Node.EventType.TOUCH_START, this.onLeftStartTouch, this);
          this.pageList[0].node.on(cc.Node.EventType.TOUCH_MOVE, this.onLeftMove, this);
          this.pageList[0].node.on(cc.Node.EventType.TOUCH_CANCEL, this.onLeftEnd, this);
          this.pageList[0].node.on(cc.Node.EventType.TOUCH_END, this.onLeftEnd, this);
          this.pageList[5].node.on(cc.Node.EventType.TOUCH_START, this.onRightStartTouch, this);
          this.pageList[5].node.on(cc.Node.EventType.TOUCH_MOVE, this.onRightMove, this);
          this.pageList[5].node.on(cc.Node.EventType.TOUCH_CANCEL, this.onRightEnd, this);
          this.pageList[5].node.on(cc.Node.EventType.TOUCH_END, this.onRightEnd, this);
          this.createRenderTexture();
          this.pushCreatePage(this.curPage);
          this.pushCreatePage(this.curPage + 1);
          this.pushCreatePage(this.curPage + 2);
          this.pushCreatePage(this.curPage + 3);
          this.pushCreatePage(this.curPage - 2);
          this.pushCreatePage(this.curPage - 1);
          this.blockNode.active = true;
          await new Promise(resolve => {
            this.createPageProcess(resolve);
            this.blockNode.active = false;
          });
          await this.reset();
        }

        close() {
          this.pageList[0].targetOff(this);
          this.pageList[5].targetOff(this);
          this.destroyRenderTexture();
        }

        reset() {
          this.setPageProgress(this.curPage, 0);
          this.setPageProgress(this.curPage + 1, 0);
        }

        pushCreatePage(page) {
          this.beCreatePageList.push(page);
        }

        createPageProcess(cb) {
          if (this.beCreatePageList.length) {
            let page = this.beCreatePageList.shift();
            let index = page - this.curPage + 2;
            let target = this.pageList[index];

            if (page > 0 && page <= this.sumPage) {
              this.pageCamera.enabled = true;
              this.pageCamera.targetTexture = target.getComponent(cc.Sprite).spriteFrame.texture;
              this.initContent(page, () => {
                this.scheduleOnce(() => {
                  if (JSB) {
                    this.scheduleOnce(() => {
                      this.scheduleOnce(() => {
                        this.scheduleOnce(() => {
                          this.createPageProcess(cb);
                          this.pageCamera.targetTexture = null;
                          this.pageCamera.enabled = false;
                        }, 0.1);
                      });
                    });
                  } else {
                    this.createPageProcess(cb); // this.pageCamera.enabled = false;
                  }
                });
              });
            } else {
              this.createPageProcess(cb);
            }
          } else {
            this.pageCamera.targetTexture = null;
            this.pageCamera.enabled = false;
            this.pageList[0].node.setSiblingIndex(0);
            this.pageList[5].node.setSiblingIndex(1);
            this.pageList[2].node.setSiblingIndex(2);
            this.pageList[3].node.setSiblingIndex(3);
            this.pageList[1].node.setSiblingIndex(4);
            this.pageList[4].node.setSiblingIndex(5);
            cb();
          }
        }

        initContent(page, cb) {
          this.pageNumNode.getComponent(cc.Label).string = page.toString();
        }

        onLeftStartTouch(event) {
          this.leftStartX = event.getUILocation().x;
        }

        onLeftMove(event) {
          let x = event.getUILocation().x - this.leftStartX;
          this.setPageProgress(this.curPage, x / 100);
        }

        onLeftEnd(event) {
          let x = event.getUILocation().x - this.leftStartX;
          let progress = x / 100;
          this.leftNext(progress);
        }

        pageNext(page, progress, force = false) {
          this.progress = progress;
          let isLeft = page % 2 == 1;
          let isCanNext = isLeft ? this.isCanPre() : this.isCanNext();
          this.blockNode.active = true;

          if ((progress > 0.6 || force) && isCanNext) {
            let time = Math.max(0.01, (2 - progress) * 0.25); // @ts-ignore

            cc.tween(this).to(time, {
              progress: 2
            }, {
              onUpdate: () => {
                this.setPageProgress(page, this.progress);
              }
            }).call(() => {
              if (page % 2 == 1) {
                this.curPage -= 2;
                let page1 = this.pageList.pop();
                let page2 = this.pageList.pop();
                this.pageList.unshift(page1);
                this.pageList.unshift(page2);
                this.pushCreatePage(this.curPage - 2);
                this.pushCreatePage(this.curPage - 1);
                this.createPageProcess(() => {
                  this.reset();
                  this.blockNode.active = false;
                });
              } else {
                this.curPage += 2;
                let page1 = this.pageList.shift();
                let page2 = this.pageList.shift();
                this.pageList.push(page1);
                this.pageList.push(page2);
                this.pushCreatePage(this.curPage + 2);
                this.pushCreatePage(this.curPage + 3);
                this.createPageProcess(() => {
                  this.reset();
                });
              }
            }).start();
          } else {
            this.progress = ZombiepediaPanel.clamp(progress, 0, 1);
            let time = ZombiepediaPanel.clamp(progress * 0.5, 0.01, 0.2); // @ts-ignore

            cc.tween(this).to(time, {
              progress: 0
            }, {
              onUpdate: () => {
                this.setPageProgress(page, this.progress);
              }
            }).call(() => {
              this.blockNode.active = false;
            }).start();
          }
        }

        static clamp(value, min, max) {
          return value > max ? max : value < min ? min : value;
        }

        leftNext(progress, force = false) {
          this.pageNext(this.curPage, progress, force);
        }

        onRightStartTouch(event) {
          this.rightStartX = event.getUILocation().x;
        }

        onRightMove(event) {
          let x = event.getUILocation().x - this.rightStartX;
          this.setPageProgress(this.curPage + 1, -x / 100);
        }

        onRightEnd(event) {
          let x = event.getUILocation().x - this.rightStartX;
          let progress = -x / 100;
          this.rightNext(progress);
        }

        rightNext(progress, force = false) {
          this.pageNext(this.curPage + 1, progress, force);
        }

        getLerpColor(progress) {
          progress = ZombiepediaPanel.clamp(progress, 0, 1);
          return cc.Color.lerp(cc.color(), cc.color("#828C96"), cc.Color.WHITE, progress);
        }

        setPageProgress(page, progress) {
          let isLeft = page % 2 == 1;
          let isCanNext = isLeft ? this.isCanPre() : this.isCanNext();
          let clip = isCanNext ? 1 : 0;
          page = page - this.curPage + 2;
          let showPage = page;
          let nextPage = isLeft ? page - 1 : page + 1;
          let bottomPage = isLeft ? page - 2 : page + 2;
          let otherShow = isLeft ? page + 1 : page - 1;
          let clip1 = this.pageList[0].clips[clip];
          let clip2 = this.pageList[0].clips[1];

          if (progress <= 1 || !isCanNext) {
            this.pageList[showPage].createState(clip1).setTime(ZombiepediaPanel.clamp(1 - progress, 0.05, 1));
            this.pageList[nextPage].createState(clip2).setTime(0);
            this.pageList[bottomPage].createState(clip2).setTime(1);
            this.pageList[bottomPage].getComponent(cc.Sprite).color = this.getLerpColor(isCanNext ? progress : 0);
            this.pageList[otherShow].getComponent(cc.Sprite).color = this.getLerpColor(1);
            this.pageList[nextPage].getComponent(cc.Sprite).color = this.getLerpColor(1);
          } else if (progress > 1) {
            this.pageList[bottomPage].getComponent(cc.Sprite).color = this.getLerpColor(1);
            this.pageList[otherShow].getComponent(cc.Sprite).color = this.getLerpColor(2 - progress);
            this.pageList[bottomPage].createState(clip2).setTime(1);
            this.pageList[showPage].createState(clip2).setTime(0);
            this.pageList[nextPage].createState(clip2).setTime(ZombiepediaPanel.clamp(progress - 1, 0.05, 1));
          }

          this.pageList[showPage].getState(clip1.name).sample();
          this.pageList[nextPage].getState(clip2.name).sample();
          this.pageList[bottomPage].getState(clip2.name).sample();
        }

        prePage() {
          if (this.isCanPre()) {
            this.leftNext(0, true);
          }
        }

        isCanPre() {
          return this.curPage > 1;
        }

        isCanNext() {
          return this.curPage < this.sumPage - 1;
        }

        nextPage() {
          if (this.isCanNext()) {
            this.rightNext(0, true);
          }
        }

        hide() {}

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "pageList", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return [];
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "pageCamera", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "firstPageNode", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "pageNumNode", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "blockNode", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=6f9c57abde691e856ee36a9d85745fd6efa1d944.js.map