System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, MathUtils, _crd;

  _export("MathUtils", void 0);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "ca951vmwbFOIqrIDyK6IU/R", "MathUtils", undefined);

      /**
       * 数学计算工具类
       */
      _export("MathUtils", MathUtils = class MathUtils {
        static clamp(a, b, x) {
          if (a > b) {
            let t = a;
            a = b;
            b = t;
          }

          if (x < a) return a;
          if (x > b) return b;
          return x;
        }
        /**
         * 弧度制转换为角度值
         * @param radian 弧度制
         * @returns {number}
         */


        static getAngle(radian) {
          return 180 * radian / Math.PI;
        }
        /**
         * 角度值转换为弧度制
         * @param angle
         */


        static getRadian(angle) {
          return angle / 180 * Math.PI;
        }
        /**
         * 获取两点间弧度
         * @param p1X
         * @param p1Y
         * @param p2X
         * @param p2Y
         * @returns {number}
         */


        static getRadian2(p1X, p1Y, p2X, p2Y) {
          var xdis = p2X - p1X;
          var ydis = p2Y - p1Y;
          return Math.atan2(ydis, xdis);
        }
        /**
         * 获取两点间距离
         * @param p1X
         * @param p1Y
         * @param p2X
         * @param p2Y
         * @returns {number}
         */


        static getDistance(p1X, p1Y, p2X, p2Y) {
          var disX = p2X - p1X;
          var disY = p2Y - p1Y;
          var disQ = disX * disX + disY * disY;
          return Math.sqrt(disQ);
        }

        static toFixedStr(value, fixCount) {
          return value.toFixed(fixCount).replace(/\.?0*$/, '');
        }

        static toPercentStr(value, fixCount) {
          return this.toFixedStr(value * 100, fixCount) + "%";
        }

        static toFixedWan(value) {
          const wanFix = 100000;
          let wanFloat = wanFix / 10;
          var v = Math.floor(value / wanFloat) * wanFloat;
          return value > wanFix ? `${MathUtils.toFixedStr(v / wanFix * 10, 1)}万` : value.toString();
        } //value = ceil(e*(a*(level^d) + b*(level) + c))


        static getFinalValueBasedOnParams(level, paramList, needCeil) {
          if (paramList.length < 5) {
            return 0;
          }

          let ret = paramList[4] * (paramList[0] * Math.pow(level, paramList[3]) + paramList[1] * level + paramList[2]);

          if (needCeil) {
            ret = Math.ceil(ret);
          }

          return ret;
        }
        /**
        * 获取一个区间的随机数
        * @param $from 最小值
        * @param $end 最大值
        * @returns {number}
        */


        static limit($from, $end) {
          $from = Math.min($from, $end);
          $end = Math.max($from, $end);
          var range = $end - $from;
          return $from + Math.random() * range;
        }
        /**
         * 获取一个区间的随机数(帧数)
         * @param $from 最小值
         * @param $end 最大值
         * @returns {number}
         */


        static limitInteger($from, $end) {
          return Math.round(MathUtils.limit($from, $end));
        }
        /**
         * 在一个数组中随机获取一个元素
         * @param arr 数组
         * @returns {any} 随机出来的结果
         */


        static randomArray(arr) {
          var index = Math.floor(Math.random() * arr.length);
          return arr[index];
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=d47150555a7b74fecd91769981b5b1d457121898.js.map