System.register(["__unresolved_0", "cc", "__unresolved_1"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _cc, MathUtils, CommonUtils, _crd, cc;

  function _reportPossibleCrUseOfMathUtils(extras) {
    _reporterNs.report("MathUtils", "../Utils/MathUtils", _context.meta, extras);
  }

  _export("CommonUtils", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc2) {
      _cclegacy = _cc2.cclegacy;
      __checkObsolete__ = _cc2.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc2.__checkObsoleteInNamespace__;
      _cc = _cc2;
    }, function (_unresolved_2) {
      MathUtils = _unresolved_2.MathUtils;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "cf0449Ivk5Jvr4PGtPvHEE6", "CommonUtils", undefined);

      cc = __checkObsoleteInNamespace__(_cc);

      _export("CommonUtils", CommonUtils = class CommonUtils {
        // 判断一个点是否在三角形内
        static isInTriangle(point, triA, triB, triC) {
          var AB = triB.clone().subtract(triA),
              AC = triC.clone().subtract(triA),
              BC = triC.clone().subtract(triB),
              AD = point.clone().subtract(triA),
              BD = point.clone().subtract(triB); //@ts-ignore

          return AB.cross(AC) >= 0 ^ AB.cross(AD) < 0 && AB.cross(AC) >= 0 ^ AC.cross(AD) >= 0 && BC.cross(AB) > 0 ^ BC.cross(BD) >= 0;
        } // 将多边形分解为多个三角形


        static splitPolygon(points) {
          if (points.length <= 3) return [0, 1, 2];
          var pointMap = {}; // point与idx的映射

          for (var i = 0; i < points.length; i++) {
            var p = points[i];
            pointMap[p.x + "-" + p.y] = i;
          }

          var getIdx = p => {
            return pointMap[p.x + "-" + p.y];
          };

          points = points.concat([]);
          var idxs = [];
          var index = 0;

          while (points.length > 3) {
            var p1 = points[index % points.length],
                p2 = points[(index + 1) % points.length],
                p3 = points[(index + 2) % points.length];
            var splitPoint = (index + 1) % points.length;
            var v1 = p2.clone().subtract(p1);
            var v2 = p3.clone().subtract(p2);

            if (v1.cross(v2) < 0) {
              // 是一个凹角, 寻找下一个
              index = (index + 1) % points.length;
              continue;
            }

            var hasPoint = false;

            for (var _p of points) {
              if (_p != p1 && _p != p2 && _p != p3 && this.isInTriangle(_p, p1, p2, p3)) {
                hasPoint = true;
                break;
              }
            }

            if (hasPoint) {
              // 当前三角形包含其他点, 寻找下一个
              index = (index + 1) % points.length;
              continue;
            } // 找到了耳朵, 切掉


            idxs.push(getIdx(p1), getIdx(p2), getIdx(p3));
            points.splice(splitPoint, 1);
          }

          for (var _p2 of points) {
            idxs.push(getIdx(_p2));
          }

          return idxs;
        }
        /** 计算uv, 锚点都是中心 */


        static computeUv(points, width, height) {
          var uvs = [];

          for (var p of points) {
            // uv原点是左上角
            var x = (_crd && MathUtils === void 0 ? (_reportPossibleCrUseOfMathUtils({
              error: Error()
            }), MathUtils) : MathUtils).clamp(0, 1, (p.x + width / 2) / width);
            var y = (_crd && MathUtils === void 0 ? (_reportPossibleCrUseOfMathUtils({
              error: Error()
            }), MathUtils) : MathUtils).clamp(0, 1, 1. - (p.y + height / 2) / height);
            uvs.push(cc.v2(x, y));
          }

          return uvs;
        }
        /** 使用线段切割多边形 */


        static splitPolygonByLine(a, b, polygon) {
          var lint = {
            type: "LineString",
            coordinates: [[a.x, a.y], [b.x, b.y]]
          };
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=0f5fc045d6e4dcac24b212052ee20e3ad4443fd9.js.map