System.register(["__unresolved_0", "cc"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, dynamicAtlasManager, Vec3, _crd, vec3_temps, i, floatsPerVert, TextureAssembler;

  function _reportPossibleCrUseOfTexturePlus(extras) {
    _reporterNs.report("TexturePlus", "../Components/TexturePlus", _context.meta, extras);
  }

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      dynamicAtlasManager = _cc.dynamicAtlasManager;
      Vec3 = _cc.Vec3;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "e0687tDW69CxalPcgT1Omra", "TextureAssembler", undefined);

      __checkObsolete__(['dynamicAtlasManager', 'IAssembler', 'IRenderData', 'RenderData', 'sp', 'Sprite', 'Vec2', 'Vec3']);

      vec3_temps = [];

      for (i = 0; i < 4; i++) {
        vec3_temps.push(new Vec3());
      }
      /**
       * simple 组装器
       * 可通过 `UI.simple` 获取该组装器。
       */


      floatsPerVert = 9;

      _export("TextureAssembler", TextureAssembler = {
        createData(sprite) {
          var renderData = sprite.requestRenderData();
          var points = sprite.uvList;
          if (!points || points.length < 3) return;
          renderData.dataLength = points.length;
          var indicesCount = sprite.indices.length;
          renderData.resize(points.length, indicesCount); // @ts-ignore

          renderData.chunk.setIndexBuffer(sprite.indices);
          return renderData;
        },

        updateRenderData(sprite) {
          var frame = sprite.spriteFrame;
          dynamicAtlasManager.packToDynamicAtlas(sprite, frame);
          this.updateUVs(sprite); // dirty need
          //this.updateColor(sprite);// dirty need

          var renderData = sprite.renderData;

          if (renderData && frame) {
            if (renderData.vertDirty) {
              this.updateVertexData(sprite);
            }

            renderData.updateRenderData(sprite, frame);
          }
        },

        updateWorldVerts(sprite, chunk) {
          var renderData = sprite.renderData;
          var vData = chunk.vb;
          var dataList = renderData.data;
          var node = sprite.node;
          var matrix = node.worldMatrix;
          var stride = renderData.floatStride;
          var vec3_temp = vec3_temps[0];
          var offset = 0;

          for (var _i = 0; _i < dataList.length; _i++) {
            var curData = dataList[_i];
            Vec3.set(vec3_temp, curData.x, curData.y, 0);
            Vec3.transformMat4(vec3_temp, vec3_temp, matrix);
            offset = _i * stride;
            vData[offset++] = vec3_temp.x;
            vData[offset++] = vec3_temp.y;
            vData[offset++] = vec3_temp.z;
          }
        },

        fillBuffers(sprite, renderer) {
          if (sprite === null) {
            return;
          }

          var renderData = sprite.renderData;
          var chunk = renderData.chunk;

          if (sprite.node.hasChangedFlags || renderData.vertDirty) {
            // const vb = chunk.vertexAccessor.getVertexBuffer(chunk.bufferId);
            this.updateWorldVerts(sprite, chunk);
            renderData.vertDirty = false;
          }

          var bid = chunk.bufferId;
          var vidOrigin = chunk.vertexOffset; // @ts-ignore

          var meshBuffer = chunk.meshBuffer; // @ts-ignore

          var ib = chunk.meshBuffer.iData;
          var indexOffset = meshBuffer.indexOffset;
          var vid = vidOrigin;
          var iData = sprite.indices;

          for (var _i2 = 0, l = iData.length; _i2 < l; _i2++) {
            ib[indexOffset++] = vid + iData[_i2];
          }

          meshBuffer.indexOffset += iData.length;
        },

        updateVertexData(sprite) {
          var renderData = sprite.renderData;

          if (!renderData) {
            return;
          }

          var uiTrans = sprite.node._uiProps.uiTransformComp;
          var dataList = renderData.data;
          var cw = uiTrans.width;
          var ch = uiTrans.height;
          var appX = uiTrans.anchorX * cw;
          var appY = uiTrans.anchorY * ch;
          var l = 0;
          var b = 0;
          var r = 0;
          var t = 0;

          if (sprite.trim) {
            l = -appX;
            b = -appY;
            r = cw - appX;
            t = ch - appY;
          } else {
            var frame = sprite.spriteFrame;
            var originSize = frame.originalSize;
            var ow = originSize.width;
            var oh = originSize.height;
            var scaleX = cw / ow;
            var scaleY = ch / oh; // @ts-ignore

            var trimmedBorder = frame.trimmedBorder;
            l = trimmedBorder.x * scaleX - appX;
            b = trimmedBorder.z * scaleY - appY;
            r = cw + trimmedBorder.y * scaleX - appX;
            t = ch + trimmedBorder.w * scaleY - appY;
          }

          var startX = l;
          var startY = b;
          var subX = r - l;
          var subY = t - b;

          for (var _i3 = 0; _i3 < sprite.uvList2.length; ++_i3) {
            var pos = sprite.uvList2[_i3];
            var x = sprite.flipX ? 1 - pos.x : pos.x;
            dataList[_i3].x = x * subX + startX;
            dataList[_i3].y = pos.y * subY + startY;
          }

          renderData.vertDirty = true;
        },

        updateUVs(sprite) {
          if (!sprite.spriteFrame) return;
          var renderData = sprite.renderData;
          var vData = renderData.chunk.vb;
          var uv = sprite.spriteFrame.uv;
          var polygon = sprite.uvList;
          var startX = uv[0];
          var startY = uv[1];
          var subX = uv[6] - startX;
          var subY = uv[7] - startY;
          var uvOffset = 3;

          for (var _i4 = 0; _i4 < polygon.length; _i4++) {
            var pos = polygon[_i4];
            var rx = sprite.flipX ? 1 - pos.x : pos.x;
            var dstOffset = floatsPerVert * _i4 + uvOffset;
            vData[dstOffset] = startX + rx * subX;
            vData[dstOffset + 1] = startY + pos.y * subY;
          }
        },

        updateColor(sprite) {
          var renderData = sprite.renderData;
          var vData = renderData.chunk.vb;
          var colorOffset = 5;
          var color = sprite.color;
          var colorR = color.r / 255;
          var colorG = color.g / 255;
          var colorB = color.b / 255;
          var colorA = sprite.node._uiProps.opacity;

          for (var _i5 = 0; _i5 < sprite.uvList.length; _i5++, colorOffset += renderData.floatStride) {
            vData[colorOffset] = colorR;
            vData[colorOffset + 1] = colorG;
            vData[colorOffset + 2] = colorB;
            vData[colorOffset + 3] = colorA;
          }
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=6f9388ba471f23680319c6578cfb8c8768eebd58.js.map