
import * as cc from 'cc';
const { ccclass, property } = cc._decorator;
const _v3_0 = new cc.Vec3();

@ccclass('Follow')
export class Follow extends cc.Component {
    @property({ type: cc.Node })
    public target: cc.Node | null = null;

    @property({ type: cc.Camera })
    public camera: cc.Camera | null = null;

    @property({ type: cc.Sprite })
    public render: cc.Sprite | null = null;

    start() {
        // 打开以下这行看效果
        // return;


        let size = cc.view.getDesignResolutionSize();
        let renderTex = new cc.RenderTexture();
        renderTex.reset({
            width: size.width,
            height: size.height,
        });

        let sp: cc.SpriteFrame = new cc.SpriteFrame();
        this.camera!.targetTexture = renderTex;
        sp.texture = renderTex;
        this.render!.spriteFrame = sp;
    }


    lateUpdate(dt: number) {
        if (!this.target || !this.camera) return;

        this.target.getWorldPosition(_v3_0);
        this.camera.convertToUINode(_v3_0, this.node.parent!, _v3_0);
        this.node.setPosition(new cc.Vec3(_v3_0.x, _v3_0.y, _v3_0.z));
    }
}
