import { IBuildTaskOption } from '../@types';
import { IBuildResult } from '../@types';

interface IOptions {
    commonTest1: number;
    commonTest2: 'opt1' | 'opt2';
    webTestOption: boolean;
}

const PACKAGE_NAME = 'cocos-build-template';

interface ITaskOptions extends IBuildTaskOption {
    packages: {
        'cocos-plugin-template': IOptions;
    };
}

function log(...arg: any[]) {
    return console.log(`[${PACKAGE_NAME}] `, ...arg);
}

let allAssets = [];

export const throwError = true;

export async function load() {
    console.log(`[${PACKAGE_NAME}] Load cocos plugin example in builder.`);
    allAssets = await Editor.Message.request('asset-db', 'query-assets');
}

export async function onBeforeBuild(options: ITaskOptions) {
    // Todo some thing
    log(`${PACKAGE_NAME}.webTestOption`, 'onBeforeBuild');
}

export async function onBeforeCompressSettings(options: ITaskOptions, result: IBuildResult) {
    const pkgOptions = options.packages[PACKAGE_NAME];
    if (pkgOptions.webTestOption) {
        console.debug('webTestOption', true);
    }
    // Todo some thing
    console.debug('get settings test', result.settings);
}

export async function onAfterCompressSettings(options: ITaskOptions, result: IBuildResult) {
    // Todo some thing
    console.log('webTestOption', 'onAfterCompressSettings');
}

export async function onAfterBuild(options: ITaskOptions, result: IBuildResult) {
    // change the uuid to test
    const uuidTestMap = {
        atlas: '5e69c841-9f83-4176-9207-f6d54dd2fc15',
        image: '77888f65-738f-4a7f-941a-3628eab69614',
        spriteFrame: '77888f65-738f-4a7f-941a-3628eab69614@f9941',
        texture: '77888f65-738f-4a7f-941a-3628eab69614@6c48a',
    }
    for (const name of Object.keys(uuidTestMap)) {
        const uuid = uuidTestMap[name];
        console.debug(`containsAsset of ${uuid}`, result.containsAsset(uuid));
        console.debug(`getAssetPathInfo of ${uuid}`, result.getAssetPathInfo(uuid));
        console.debug(`getRawAssetPaths of ${uuid}`, result.getRawAssetPaths(uuid));
        console.debug(`getJsonPathInfo of ${uuid}`, result.getJsonPathInfo(uuid));
    }
}

export function unload() {
    console.log(`[${PACKAGE_NAME}] Unload cocos plugin example in builder.`);
}
