import Joystick from "./joystick";
import Robot from "./robot";

const { ccclass, property } = cc._decorator;


@ccclass
export default class HelloWorld extends cc.Component {
    @property(Robot)
    robot1: Robot = null;
    @property(Joystick)
    joystickL: Joystick = null;

    private _posL: cc.Vec2;

    onLoad() {
        //物理
        cc.director.getPhysicsManager().enabled = true;

        this.joystickL.onChangePosition(pt => {
            this._posL = pt;
        })
        this.joystickL.onChangeType(val => {
            if (val == -1) {
                this._posL = null;
            }
        })
    }
    onClickL() {
        //测试前进
        this.robot1.doGoFront()
    }
    onClickR() {
        //测试后退
        this.robot1.doGoBack()
    }

    update() {
        this.robot1.updateView(this._posL);
    }
}
