const { ccclass, property } = cc._decorator;

@ccclass
export default class Joystick extends cc.Component {
    @property(cc.Node)
    panel: cc.Node = null;
    @property(cc.Node)
    range: cc.Node = null;
    @property(cc.Node)
    range2: cc.Node = null;
    @property(cc.Node)
    point: cc.Node = null;

    _ptS: cc.Vec2

    onLoad() {
        var w = Math.floor(this.range.width / 2);
        var w2 = Math.floor(this.range2.width / 2);
        this.node.on(cc.Node.EventType.TOUCH_START, (e: cc.Event.EventTouch) => {
            var pt = e.getLocation();
            this.panel.setPosition(this.node.convertToNodeSpaceAR(pt));
            this._ptS = pt;
            this.changePosition(cc.v2());
        });
        this.node.on(cc.Node.EventType.TOUCH_MOVE, (e: cc.Event.EventTouch) => {
            var pt = e.getLocation();
            var ptOffset = pt.sub(this._ptS)
            var d = ptOffset.mag()
            if (d < w) {
                this.changeType(0);
            }
            else if (d < w2) {
                this.changeType(1);
            }
            else {
                this.changeType(2);
                //拖动整个panel
                //计算拖出去多少
                //获取两个坐标点弧度
                var getRoundAng = function (oX, oY, nX, nY) {
                    //获取水平线夹角弧度
                    var lenA = nX - oX;
                    var lenB = nY - oY;
                    var lenC = Math.sqrt(lenA * lenA + lenB * lenB);
                    var ang = Math.acos(lenA / lenC);

                    if (nY < oY) {
                        ang = ang * -1
                    } else {
                        ang = ang * 1
                    }
                    return ang
                }
                var oX = this._ptS.x;
                var oY = this._ptS.y;
                var r = w2;
                var nX = pt.x;
                var nY = pt.y;
                var ang = getRoundAng(oX, oY, nX, nY)
                //获取线段上某个点的坐标
                nX = oX + (r * Math.cos(ang))
                nY = oY + (r * Math.sin(ang))
                var pt_ = cc.v2(nX, nY)
                ptOffset = pt_.sub(this._ptS)

                this._ptS = pt.sub(pt_).add(this._ptS)
                this.panel.setPosition(this.node.convertToNodeSpaceAR(this._ptS));
            }
            this.changePosition(ptOffset);
        });
        this.node.on(cc.Node.EventType.TOUCH_END, () => {
            this.changeType(-1);
        });
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, () => {
            this.changeType(-1);
        });
    }
    private changePosition(pt: cc.Vec2) {
        this.point.setPosition(pt);
        if (this._changePositionCallback) {
            this._changePositionCallback(pt)
        }
    }
    private changeType(val: number) {
        this._changeTypeCallback(val)
    }
    private _changePositionCallback
    onChangePosition(callback: (pt: cc.Vec2) => void) {
        this._changePositionCallback = callback;
    }
    private _changeTypeCallback
    onChangeType(callback: (val: number) => void) {
        this._changeTypeCallback = callback;
    }
}
