
const { ccclass, property } = cc._decorator;

@ccclass
export default class Robot extends cc.Component {
    @property(cc.Node)
    bodyNode: cc.Node = null;
    onLoad() {
        var cfg = {
            "bArmR": { "x": -36.73167502717956, "y": -71.26680151811615, "r": 26.075222696091924 },
            "sArmR": { "x": -84.12520721400722, "y": -125.41205191430441, "r": 97.64954960014275 },
            "handR": { "x": -171.4872491907263, "y": -102.21174694331881, "r": 84.98207076880239 },
            "bLegR": { "x": -26.472588932057647, "y": -261.09423744236386, "r": 39.45236760187653 },
            "sLegR": { "x": -51.24073628699716, "y": -404.23880619042814, "r": -15.795124940345598 },
            "legR": { "x": -35.04997877134531, "y": -509.5273349530505, "r": -0.034762890100647474 },
            "head": { "x": -39.40828462572176, "y": 45.80880539074269, "r": -5.7242262487103055 },
            "body": { "x": -10.593827786386669, "y": -89.92288417897316, "r": -15.501555449649645 },
            "hip": { "x": 10.730244814306161, "y": -174.29094016913444, "r": -17.501662006959357 },
            "bLegL": { "x": 44.22817411248684, "y": -273.87607604698144, "r": -14.600919865997174 },
            "sLegL": { "x": 115.29939291078142, "y": -420.6833737348517, "r": -35.65177789855819 },
            "legL": { "x": 160.31826420758637, "y": -509.5453805722849, "r": -0.006071632858568686 },
            "bArmL": { "x": 7.1729547468515875, "y": -56.907353899110944, "r": 0.9612347634509755 },
            "sArmL": { "x": -5.937305606048199, "y": -142.58005457092793, "r": 52.182621257323085 },
            "handL": { "x": -87.13057469039813, "y": -182.03889556239943, "r": 54.79972729928871 }
        };
        //获取骨骼位置
        for (const node of this.bodyNode.children) {
            var rbody = node.getComponent(cc.RigidBody);
            if (rbody) {
                var cfg_ = cfg[node.name]
                node.setPosition(cc.v2(cfg_.x, cfg_.y));
                node.angle = -cfg_.r;
                rbody.syncPosition(false);
                rbody.syncRotation(false);
            }
        }


        this.schedule(this.updateAdle, 0.2)
    }
    private _adleIndex: number = 0;
    updateAdle() {
        //空闲
        //给指定位置一点力
        var cfg = [
            { name: "hip", lv: [cc.v2(0, 150), cc.v2(0, 150), cc.v2(0, -150), cc.v2(0, -150)] },
        ];
        for (const cfg_ of cfg) {

            var node = this.bodyNode.getChildByName(cfg_.name)
            var rbody = node.getComponent(cc.RigidBody);
            if (rbody) {
                rbody.linearVelocity = cfg_.lv[this._adleIndex % cfg_.lv.length]
            }
        }
        this._adleIndex++;
        if (this._adleIndex >= 100) {
            this._adleIndex = 0;
        }
    }
    updateView(posL?: cc.Vec2, posR?: cc.Vec2) {
        if (posL) {
            var node = this.bodyNode.getChildByName("handR")
            var rbody = node.getComponent(cc.RigidBody);
            if (rbody) {
                var pt = posL.mul(100);
                rbody.linearVelocity = pt;
            }
        }
    }


    //

    private _index: number = 0;
    doGoBack() {
        var node, rbody

        //用线性速度
        var offX = 10;

        node = this.bodyNode.getChildByName("body")
        rbody = node.getComponent(cc.RigidBody);
        rbody.linearVelocity = cc.v2(500 * offX, 0);
        if (this._index % 2 == 0) {
            node = this.bodyNode.getChildByName("sLegR")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(100 * offX, 100);
            node = this.bodyNode.getChildByName("legR")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(1000 * offX, 1000);
        }
        else {
            node = this.bodyNode.getChildByName("sLegL")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(100 * offX, 100);
            node = this.bodyNode.getChildByName("legL")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(1000 * offX, 1000);
        }

        this._index++;
    }
    doGoFront() {
        var node, rbody

        var offX = -10;

        node = this.bodyNode.getChildByName("body")
        rbody = node.getComponent(cc.RigidBody);
        rbody.linearVelocity = cc.v2(300 * offX, 0);
        if (this._index % 2 == 1) {
            node = this.bodyNode.getChildByName("sLegR")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(100 * offX, 100);
            node = this.bodyNode.getChildByName("legR")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(1000 * offX, 1000);
        }
        else {
            node = this.bodyNode.getChildByName("sLegL")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(100 * offX, 100);
            node = this.bodyNode.getChildByName("legL")
            rbody = node.getComponent(cc.RigidBody);
            rbody.linearVelocity = cc.v2(1000 * offX, 1000);
        }

        this._index++;
    }
}
