import * as cc from 'cc';
import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    cylinder: cc.Node = null!;

    onLoad() {
        this.cylinder = cc.find('Canvas/Cylinder')!;
        this.onShow3DModel();
    }

    onShow3DModel() {
        this.cylinder.layer = cc.Layers.Enum.UI_3D;
        let umr = this.cylinder.getComponent(cc.UIMeshRenderer)!;
        if (umr) {
            umr.destroy();
        }
        cc.find('Canvas/Buttons/Show3D')!.active = false;
        cc.find('Canvas/Buttons/ShowUI')!.active = true;
    }

    onShowUIMode() {
        this.cylinder.layer = cc.Layers.Enum.UI_2D;
        let umr = this.cylinder.getComponent(cc.UIMeshRenderer)!;
        if (!umr) {
            this.cylinder.addComponent(cc.UIMeshRenderer);
        }
        cc.find('Canvas/Buttons/Show3D')!.active = true;
        cc.find('Canvas/Buttons/ShowUI')!.active = false;
    }
}
