// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class TestOne extends cc.Component {

    @property(cc.Node)
    touchMe:cc.Node
    @property(cc.Label)
    touchTxt:cc.Label

    txtnode:cc.Node

    onTouchMe(){
        let self = this
        if (self.touchTxt.string == '释放'){
            self.txtnode.removeFromParent()
            self.txtnode.destroy()
            self.txtnode = null
            self.touchMe.active = false
            
            cc.resources.release('textnode', cc.Prefab)
        }else{
            cc.resources.load('textnode', cc.Prefab, (error, assets)=>{
                self.txtnode = cc.instantiate(assets as cc.Prefab)
                self.node.addChild( self.txtnode)
                self.touchTxt.string = '释放'
            })
        }
    }

}
