Shader "Custom/GradientMask"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}
        _GradientDirection ("Gradient Direction", Vector) = (0, 1, 0, 0)
        _GradientStart ("Gradient Start", Range(0, 1)) = 0.0
        _GradientEnd ("Gradient End", Range(0, 1)) = 1.0
    }
    
    SubShader
    {
        Tags { "Queue" = "Transparent" "RenderType" = "Transparent" }
        LOD 100
        
        Blend SrcAlpha OneMinusSrcAlpha
        ZWrite Off
        Cull Off
        
        Pass
        {
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            #include "UnityCG.cginc"
            
            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };
            
            struct v2f
            {
                float2 uv : TEXCOORD0;
                float4 vertex : SV_POSITION;
            };
            
            sampler2D _MainTex;
            float4 _MainTex_ST;
            float4 _GradientDirection;
            float _GradientStart;
            float _GradientEnd;
            
            v2f vert (appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                return o;
            }
            
            fixed4 frag (v2f i) : SV_Target
            {
                fixed4 col = tex2D(_MainTex, i.uv);
                
                // 计算沿指定方向的梯度值
                float gradientValue = dot(i.uv, normalize(_GradientDirection.xy));
                
                // 基于梯度范围计算透明度
                float alpha = smoothstep(_GradientStart, _GradientEnd, gradientValue);
                
                col.a *= alpha;
                return col;
            }
            ENDCG
        }
    }
} 