import { assetManager, Component, director, game, macro, Sprite, sys, _decorator } from 'cc';
const { ccclass, property } = _decorator;

declare module 'cc' {
    interface Macro {
        /**res.md5码.zip */
        remote_res: string;
        /**config.md5码.json */
        remote_config: string;
    }
}

@ccclass('loading')
export class loding extends Component {
    @property(Sprite)
    loadingBar: Sprite;
    start() {

        if (sys.platform == sys.Platform.WECHAT_GAME) {
            const remote_server_address = game.config.assetOptions.server;

            console.log('旧版本资源缓存:', assetManager.cacheManager.cachedFiles);

            /**找出旧版资源缓存删除掉 */
            if (macro.remote_config && macro.remote_res) {
                let needClearRes = Object.keys(assetManager.cacheManager.cachedFiles).filter(url => {
                    return url != remote_server_address + 'remote/resources/' + macro.remote_config || url != remote_server_address + 'remote/resources/' + macro.remote_res;
                });
                needClearRes.forEach(url => {
                    console.log('删除旧版资源缓存：', url);
                    assetManager.cacheManager.removeCache(url);
                });
            }

            assetManager.loadBundle(remote_server_address + 'remote/resources', {
                cacheEnabled: true,
                version: game.config.assetOptions.bundleVers.resources,
                onFileProgress: (loaded: any) => {
                    if (loaded.progress < 100) {
                        //zip下载进度
                        this.loadingBar.fillRange = loaded.progress / 100;
                    } else {
                        //下载完成 解压
                    }
                }
            }, (err, bundle) => {
                //zip包下载解压完毕 进入游戏
                director.loadScene('main');
            });
        }
    }

    update(deltaTime: number) {

    }
}

