"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onAfterBuild = exports.unload = exports.load = exports.throwError = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
exports.throwError = true;
const load = async function () { };
exports.load = load;
const unload = async function () { };
exports.unload = unload;
/**构建完成之后调用 */
const onAfterBuild = async function (options, result) {
    let buildPath = result.dest;
    let settingJsonFile = (0, fs_1.readdirSync)((0, path_1.join)(buildPath, 'src')).filter(v => {
        return v.indexOf('settings') != -1;
    })[0];
    if (settingJsonFile) {
        let settingJson = JSON.parse((0, fs_1.readFileSync)((0, path_1.join)(buildPath, 'src', settingJsonFile), 'utf-8'));
        //取消引擎默认加载zip
        settingJson.hasResourcesBundle = false;
        //写入本次构建后的资源文件
        settingJson.macros = {};
        (0, fs_1.readdirSync)((0, path_1.join)(buildPath, 'remote/resources')).forEach(v => {
            settingJson.macros['remote_' + v.split('.')[0]] = v;
        });
        (0, fs_1.writeFileSync)((0, path_1.join)(buildPath, 'src', settingJsonFile), JSON.stringify(settingJson));
    }
};
exports.onAfterBuild = onAfterBuild;
