import { readdirSync, readFileSync, writeFileSync } from 'fs';
import { join } from 'path';
import { BuildHook } from '../@types/packages/builder/@types';


export const throwError: BuildHook.throwError = true;

export const load: BuildHook.load = async function () { };

export const unload: BuildHook.unload = async function () { };

/**构建完成之后调用 */
export const onAfterBuild: BuildHook.onAfterBuild = async function (options, result) {

    let buildPath = result.dest;

    let settingJsonFile = readdirSync(join(buildPath, 'src')).filter(v => {
        return v.indexOf('settings') != -1;
    })[0];

    if (settingJsonFile) {
        let settingJson = JSON.parse(readFileSync(join(buildPath, 'src', settingJsonFile), 'utf-8'));

        //取消引擎默认加载zip
        settingJson.hasResourcesBundle = false;

        //写入本次构建后的资源文件
        settingJson.macros = {};
        readdirSync(join(buildPath, 'remote/resources')).forEach(v => {
            settingJson.macros['remote_' + v.split('.')[0]] = v;
        });

        writeFileSync(join(buildPath, 'src', settingJsonFile), JSON.stringify(settingJson));
    }
};