
import { _decorator, Component, Node, EventTouch, Script, Vec3, log } from 'cc';
import { terrainTS } from './terrainTS';
const { ccclass, property, executeInEditMode } = _decorator;

@ccclass('movePoint')
@executeInEditMode(true)
export class movePoint extends Component {

    public index: number = null;//需要移动的转角数组元素下标
    private terrainTS = null;//地形脚本
    private pos: Vec3 = new Vec3();//移动的合规位置
    private nodeIndex: number = null;//当前节点在父节点的 children 数组中的位置
    private frontPiont: Node = null;//当前节点在父节点的 children 数组中前面一个的位置的节点
    private afterPoints:Node = null;//当前节点在父节点的 children 数组中后面一个的位置的节点
    onLoad() {
        this.terrainTS = this.node.parent.parent.getComponent(terrainTS);//获取地形脚本
        this.node.on(Node.EventType.TOUCH_START, this.touchStart, this);//注册触碰屏幕事件
        this.node.on(Node.EventType.TOUCH_MOVE, this.touchMove, this);//注册在屏幕上移动事件
        this.node.on(Node.EventType.TOUCH_END, this.touchEnd, this);//注册手指离开屏幕事件
        this.node.on(Node.EventType.TOUCH_CANCEL, this.touchEnd, this);//注册手指离开屏幕事件
    }
    onDisable() {
        this.node.off(Node.EventType.TOUCH_START, this.touchStart, this);//注销触碰屏幕事件
        this.node.off(Node.EventType.TOUCH_MOVE, this.touchMove, this);//注销在屏幕上移动事件
        this.node.off(Node.EventType.TOUCH_END, this.touchEnd, this);//注销手指离开屏幕事件
        this.node.off(Node.EventType.TOUCH_CANCEL, this.touchEnd, this);//注册手指离开屏幕事件
    }
    /*
    *开始点击
    */
    private touchStart(touch: EventTouch) {
        this.index = parseInt(this.node.name);//获取需要移动的转角数字元素下标
        this.nodeIndex = this.node.getSiblingIndex();//获取当前节点在父节点的 children 数组中的位置
        this.frontPiont = this.node.parent.children[this.nodeIndex - 1];//获取当前节点在父节点的 children 数组中前面一个的移动点
        this.afterPoints = this.node.parent.children[this.nodeIndex + 1];//获取当前节点在父节点的 children 数组中后面一个的移动点
    }
    /*
    *移动
    */
    private touchMove(touch: EventTouch) {
        if (this.nodeIndex != 0) {
            const nowpos = this.node.getPosition();//获取节点位置
            const dalta = touch.getUIDelta();//获取触点移动之间的差值
            if(dalta.x < 0){//如果向前移动
                if (nowpos.x > this.frontPiont.getPosition().x + 40) {//如果当前节点x小于等于前面一个移动点,偏移x轴40，禁止超过前面或者后面一个移动点
                    this.node.setPosition(nowpos.x += dalta.x, nowpos.y += dalta.y);//设置移动点位置
                    this.terrainTS.line_vertex[this.index] = this.node.getPosition();//更换对应移动的转角点位置
                    this.terrainTS.setLineVertex();//设置地形顶点数据
                } else {
                    this.pos = nowpos;//设置当前位置为合法位置
                    nowpos.x += 1;
                    this.node.setPosition(nowpos);//设置节点位置至移动前位置
                }
            } else {
                if(this.afterPoints){
                    if (nowpos.x < this.afterPoints.getPosition().x - 40) {//如果当前节点x小于等于前面一个移动点,偏移x轴40，禁止超过前面或者后面一个移动点
                        this.node.setPosition(nowpos.x += dalta.x, nowpos.y += dalta.y);//设置移动点位置
                        this.terrainTS.line_vertex[this.index] = this.node.getPosition();//更换对应移动的转角点位置
                        this.terrainTS.setLineVertex();//设置地形顶点数据
                    } else {
                        this.pos = nowpos;//设置当前位置为合法位置
                        nowpos.x -= 1;
                        this.node.setPosition(nowpos);//设置节点位置至移动前位置
                    }
                } else {
                    this.node.setPosition(nowpos.x += dalta.x, nowpos.y += dalta.y);//设置移动点位置
                    this.terrainTS.line_vertex[this.index] = this.node.getPosition();//更换对应移动的转角点位置
                    this.terrainTS.setLineVertex();//设置地形顶点数据
                }
            }
        }
    }
    /*
    *移动结束
    */
    private touchEnd() {
        this.terrainTS.setPoints();//设置碰撞组件points
    }
}