import { _decorator, Component, Node, SpriteFrame, Material, Prefab, Vec3, v3, MeshRenderer, Mesh, utils, Vec2, PolygonCollider2D, Texture2D, instantiate, RigidBody2D, PhysicsSystem2D, EPhysics2DDrawFlags, log, v2, MeshCollider } from 'cc';
const { ccclass, property, requireComponent } = _decorator;

@ccclass('terrainTS')
@requireComponent(MeshRenderer)
export class terrainTS extends Component {


    private vertexPos: number[] = [];

    private colliderPoints: Vec2[][] = [];

    private Uvs: number[] = [];

    @property({ type: SpriteFrame, tooltip: '精灵的精灵帧0' })
    public spriteFrame: SpriteFrame = null;
    @property({ type: Material })
    private material: Material = null;
    @property({ type: Prefab })
    public movePoint: Prefab = null;
    @property({ type: Prefab })
    public terrainCollider: Prefab = null;


    pointParent: Node = null;

    colliderParent: Node = null;

    _segment_count = 16;

    _curve_width = 512;

    min_width = 0;

    _line_vertex_segment: Vec3[] = [v3(0, 0, 0), v3(200, 0, 0), v3(400, 0, 0), v3(600, 0, 0)];


    @property({ type: Vec3, tooltip: '转角位置' })
    public line_vertex: Vec3[] = [v3(0, 200, 0), v3(200, 200, 0), v3(400, 200, 0), v3(600, 200, 0)]
    @property
    public vertexes: Vec3[] = [v3(0, 0), v3(0, 100), v3(100, 100), v3(100, 0)]

    @property({ tooltip: '地形偏移量' })
    public offSet: Vec2 = new Vec2();

    private renderer: MeshRenderer = null;节点的网格渲染组件
    private mesh: Mesh = null;节点的网格渲染组件的网格
    private _meshCache: { [key: number]: Mesh } = {};

    onLoad() {
        this.pointParent = this.node.getChildByName('pointManager');
        this.colliderParent = this.node.getChildByName('colliderManager');
        PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Shape;
        this._meshCache = {};
        this._curve_width = this.spriteFrame.getGFXTexture().height;
        let renderer: MeshRenderer = this.node.getComponent(MeshRenderer);
        if (renderer.mesh != null) {
            renderer.mesh = null;
        }
        this.renderer = renderer;
        let material = new Material();
        material.initialize({
            effectName: 'builtin-unlit',
            defines: {
                USE_TEXTURE: true,
                DepthTest: false,
                DephWrite: false,
                USE_ALPHA_TEST: true,
            },
        });
        renderer.setMaterial(material, 0);
        this.onLoadMovePoint();
        this._refreshAll();
        this.setPoints();
    }

    private _refreshAll() {
        this._updateMesh();
        this._applySpriteFrame();
        this.calculationMin();
        this.setLineVertex();
    }

    private _updateMesh() {

        let mesh: Mesh = this._meshCache[this.vertexes.length];

        if (!mesh) {
            mesh = new Mesh();
            this._meshCache[this.vertexes.length] = mesh;
        }
        this.mesh = mesh;
    }

    private _applySpriteFrame() {
        if (this.spriteFrame) {
            const renderer = this.renderer;
            let material = renderer.getMaterial(0);
            let texture = this.spriteFrame.texture;
            texture.setWrapMode(Texture2D.WrapMode.MIRRORED_REPEAT, Texture2D.WrapMode.CLAMP_TO_EDGE);
            material.setProperty('mainTexture', texture);
        }
    }

    private _applyVertexes() {

        let mesh = this.mesh;

        for (let i = 0; i < this.vertexes.length; i++) {
            this.vertexPos.push(this.vertexes[i].x);
            this.vertexPos.push(this.vertexes[i].y);
            this.vertexPos.push(0);
        }
        this._calculateUV();

        const ids = [];
        let countOfTri = this.vertexes.length - 2;
        for (let index = 0; index < countOfTri; index++) {
            ids.push(index);
            ids.push(index % 2 == 0 ? index + 2 : index + 1);
            ids.push(index % 2 == 0 ? index + 1 : index + 2);
        }
        mesh = utils.createMesh({
            positions: this.vertexPos,
            indices: ids,
            uvs: this.Uvs,
        });

        this.renderer.mesh = mesh;
        this.vertexPos.length = 0;
        this.calculationMin();
    }

    private _calculateUV() {
        const mesh = this.mesh;
        if (this.spriteFrame) {
            const texture = this.spriteFrame.texture;
            const uvs = [];
            let index = 0;
            var last_pos = null;
            for (const pt of this.vertexes) {
                var u = pt.x / texture.width;
                var v = 1 - (index % 2 == 0 ? 1 : 0);
                uvs.push(u)
                uvs.push(v)
                index += 1;
                last_pos = pt;
            }
            this.Uvs = uvs;
        }
    }

    private onLoadMovePoint() {
        const length = this.pointParent.children.length;
        if (length != this.line_vertex.length) {
            for (let i = 0; i < this.line_vertex.length; i++) {
                const movePoint = instantiate(this.movePoint);
                this.pointParent.addChild(movePoint);
                movePoint.name = '' + i;
                movePoint.setPosition(this.line_vertex[i]);
            }
            for (let i = 0; i < this.line_vertex.length - 1; i++) {
                const terrainBolck = instantiate(this.terrainCollider);
                this.colliderParent.addChild(terrainBolck);
                terrainBolck.setPosition(0, 0);
            }
        }
    }

    setLineVertex() {
        this._generateSegmentVertex(this._segment_count);
        const clone = this.line_vertex[this.line_vertex.length - 1].clone();
        this.vertexes.length = 0;
        this._line_vertex_segment.forEach(element => {
            const elementClone = element.clone();
            this.vertexes.push(elementClone.subtract(v3(0, this._curve_width, 0)));
            this.vertexes.push(element);
        });
        this.line_vertex[this.line_vertex.length - 1] = clone;
        this.vertexes = this.vertexes.reverse();
        this._applyVertexes();
    }

    setPoints() {
        for (let i = 0; i < this.colliderPoints.length; i++) {
            let colliderPointsI = this.colliderPoints[i];
            colliderPointsI.push(v2(colliderPointsI[colliderPointsI.length - 1].x, this.min_width));
            colliderPointsI.push(v2(colliderPointsI[0].x, this.min_width));
            colliderPointsI = colliderPointsI.reverse();
        }
        log('顶点')
        log(this.colliderPoints)
        for (let i = 0; i < this.colliderPoints.length; i++) {
            const nowCollider = this.colliderParent.children[i];
            const polygon = nowCollider.getComponent(PolygonCollider2D);
            polygon.points = this.colliderPoints[i];
            polygon.apply();
        }
    }

    private _generateSegmentVertex(seg_count: number) {
        this._line_vertex_segment.length = 0;
        this.colliderPoints.length = 0;
        var dynamic_seg = seg_count;

        for (let i = 0; i < this.line_vertex.length - 1; i++) {
            let p1 = this.line_vertex[i];
            let p2 = this.line_vertex[i + 1];
            let cloneP1 = this.line_vertex[i].clone();
            let cloneP2 = this.line_vertex[i + 1].clone();

            let p3 = p1.add(p2).multiplyScalar(0.5);
            this.line_vertex[i] = cloneP1;
            p1 = this.line_vertex[i];

            let para1 = 2 * 3.1415926 / (2 * (p2.x - p1.x));
            let para2 = p2.y - p3.y;

            dynamic_seg = seg_count;
            if (Math.abs(p1.y - p2.y) < 80) {
                dynamic_seg = 4;
            }

            let gap = p2.subtract(p1).multiplyScalar(1 / dynamic_seg);
            let gapClone = gap.clone();
            this.line_vertex[i + 1] = cloneP2;
            p2 = this.line_vertex[i + 1];
            this._line_vertex_segment.push(p1);
            const idx = this._line_vertex_segment.length - 1;
            let arrayClone = this._line_vertex_segment[idx].clone();

            const array: Vec2[] = [];
            array.push(v2(p1.x + this.offSet.x, p1.y + this.offSet.y));
            for (let index = 0; index < dynamic_seg - 1; index++) {
                cloneP1 = this.line_vertex[i].clone();
                const gap1 = gapClone.clone();
                let t = p1.add(gap1.multiplyScalar(index + 1));
                this.line_vertex[i] = cloneP1;
                p1 = this.line_vertex[i];
                let t_local = t.subtract(p3);
                t_local.y = Math.sin(para1 * t_local.x) * para2;
                let t_result = t_local.add(p3);
                this._line_vertex_segment.push(t_result);
                this._line_vertex_segment[idx] = arrayClone;
                array.push(v2(t_result.x + this.offSet.x, t_result.y + this.offSet.y));
            }
            array.push(v2(p2.x + this.offSet.x, p2.y + this.offSet.y));
            this.colliderPoints.push(array);
        }
        this._line_vertex_segment.push(this.line_vertex[this.line_vertex.length - 1]);
    }

    calculationMin() {
        this.min_width = 0;
        for (let i = 0; i < this.vertexes.length - 1; i++) {
            if (this.vertexes[i].y < this.min_width) {
                this.min_width = this.vertexes[i].y;
            }
        }
    }
}
