System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, _decorator, Component, SpriteFrame, Material, Prefab, Vec3, v3, MeshRenderer, Mesh, utils, Vec2, PolygonCollider2D, Texture2D, instantiate, PhysicsSystem2D, EPhysics2DDrawFlags, log, v2, _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _temp, _crd, ccclass, property, requireComponent, terrain;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      SpriteFrame = _cc.SpriteFrame;
      Material = _cc.Material;
      Prefab = _cc.Prefab;
      Vec3 = _cc.Vec3;
      v3 = _cc.v3;
      MeshRenderer = _cc.MeshRenderer;
      Mesh = _cc.Mesh;
      utils = _cc.utils;
      Vec2 = _cc.Vec2;
      PolygonCollider2D = _cc.PolygonCollider2D;
      Texture2D = _cc.Texture2D;
      instantiate = _cc.instantiate;
      PhysicsSystem2D = _cc.PhysicsSystem2D;
      EPhysics2DDrawFlags = _cc.EPhysics2DDrawFlags;
      log = _cc.log;
      v2 = _cc.v2;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "fd240MwgPFLd6kgNRK7NGhC", "terrain", undefined);

      ({
        ccclass,
        property,
        requireComponent
      } = _decorator);

      _export("terrain", terrain = (_dec = ccclass('terrain'), _dec2 = requireComponent(MeshRenderer), _dec3 = property({
        type: SpriteFrame,
        tooltip: '精灵的精灵帧0'
      }), _dec4 = property({
        type: Material
      }), _dec5 = property({
        type: Prefab
      }), _dec6 = property({
        type: Prefab
      }), _dec7 = property({
        type: Vec3,
        tooltip: '转角位置'
      }), _dec8 = property({
        tooltip: '地形偏移量'
      }), _dec(_class = _dec2(_class = (_class2 = (_temp = class terrain extends Component {
        constructor() {
          super(...arguments);

          _defineProperty(this, "vertexPos", []);

          _defineProperty(this, "colliderPoints", []);

          _defineProperty(this, "Uvs", []);

          _initializerDefineProperty(this, "spriteFrame", _descriptor, this);

          _initializerDefineProperty(this, "material", _descriptor2, this);

          _initializerDefineProperty(this, "movePoint", _descriptor3, this);

          _initializerDefineProperty(this, "terrainCollider", _descriptor4, this);

          _defineProperty(this, "pointParent", null);

          _defineProperty(this, "colliderParent", null);

          _defineProperty(this, "_segment_count", 16);

          _defineProperty(this, "_curve_width", 512);

          _defineProperty(this, "min_width", 0);

          _defineProperty(this, "_line_vertex_segment", [v3(0, 0, 0), v3(200, 0, 0), v3(400, 0, 0), v3(600, 0, 0)]);

          _initializerDefineProperty(this, "line_vertex", _descriptor5, this);

          _initializerDefineProperty(this, "vertexes", _descriptor6, this);

          _initializerDefineProperty(this, "offSet", _descriptor7, this);

          _defineProperty(this, "renderer", null);

          _defineProperty(this, "\u8282\u70B9\u7684\u7F51\u683C\u6E32\u67D3\u7EC4\u4EF6", void 0);

          _defineProperty(this, "mesh", null);

          _defineProperty(this, "\u8282\u70B9\u7684\u7F51\u683C\u6E32\u67D3\u7EC4\u4EF6\u7684\u7F51\u683C", void 0);

          _defineProperty(this, "_meshCache", {});
        }

        onLoad() {
          this.pointParent = this.node.getChildByName('pointManager');
          this.colliderParent = this.node.getChildByName('colliderManager');
          PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Shape;
          this._meshCache = {};
          this._curve_width = this.spriteFrame.getGFXTexture().height;
          var renderer = this.node.getComponent(MeshRenderer);

          if (renderer.mesh != null) {
            renderer.mesh = null;
          }

          this.renderer = renderer;
          var material = new Material();
          material.initialize({
            effectName: 'builtin-unlit',
            defines: {
              USE_TEXTURE: true,
              DepthTest: false,
              DephWrite: false,
              USE_ALPHA_TEST: true
            }
          });
          renderer.setMaterial(material, 0);
          this.onLoadMovePoint();

          this._refreshAll();

          this.setPoints();
        }

        _refreshAll() {
          this._updateMesh();

          this._applySpriteFrame();

          this.calculationMin();
          this.setLineVertex();
        }

        _updateMesh() {
          var mesh = this._meshCache[this.vertexes.length];

          if (!mesh) {
            mesh = new Mesh();
            this._meshCache[this.vertexes.length] = mesh;
          }

          this.mesh = mesh;
        }

        _applySpriteFrame() {
          if (this.spriteFrame) {
            var renderer = this.renderer;
            var material = renderer.getMaterial(0);
            var texture = this.spriteFrame.texture;
            texture.setWrapMode(Texture2D.WrapMode.MIRRORED_REPEAT, Texture2D.WrapMode.CLAMP_TO_EDGE);
            material.setProperty('mainTexture', texture);
          }
        }

        _applyVertexes() {
          var mesh = this.mesh;

          for (var i = 0; i < this.vertexes.length; i++) {
            this.vertexPos.push(this.vertexes[i].x);
            this.vertexPos.push(this.vertexes[i].y);
            this.vertexPos.push(0);
          }

          this._calculateUV();

          var ids = [];
          var countOfTri = this.vertexes.length - 2;

          for (var index = 0; index < countOfTri; index++) {
            ids.push(index);
            ids.push(index % 2 == 0 ? index + 2 : index + 1);
            ids.push(index % 2 == 0 ? index + 1 : index + 2);
          }

          mesh = utils.createMesh({
            positions: this.vertexPos,
            indices: ids,
            uvs: this.Uvs
          });
          this.renderer.mesh = mesh;
          this.vertexPos.length = 0;
          this.calculationMin();
        }

        _calculateUV() {
          var mesh = this.mesh;

          if (this.spriteFrame) {
            var texture = this.spriteFrame.texture;
            var uvs = [];
            var index = 0;
            var last_pos = null;

            for (var pt of this.vertexes) {
              var u = pt.x / texture.width;
              var v = 1 - (index % 2 == 0 ? 1 : 0);
              uvs.push(u);
              uvs.push(v);
              index += 1;
              last_pos = pt;
            }

            this.Uvs = uvs;
          }
        }

        onLoadMovePoint() {
          var length = this.pointParent.children.length;

          if (length != this.line_vertex.length) {
            for (var i = 0; i < this.line_vertex.length; i++) {
              var movePoint = instantiate(this.movePoint);
              this.pointParent.addChild(movePoint);
              movePoint.name = '' + i;
              movePoint.setPosition(this.line_vertex[i]);
            }

            for (var _i = 0; _i < this.line_vertex.length - 1; _i++) {
              var terrainBolck = instantiate(this.terrainCollider);
              this.colliderParent.addChild(terrainBolck);
              terrainBolck.setPosition(0, 0);
            }
          }
        }

        setLineVertex() {
          this._generateSegmentVertex(this._segment_count);

          var clone = this.line_vertex[this.line_vertex.length - 1].clone();
          this.vertexes.length = 0;

          this._line_vertex_segment.forEach(element => {
            var elementClone = element.clone();
            this.vertexes.push(elementClone.subtract(v3(0, this._curve_width, 0)));
            this.vertexes.push(element);
          });

          this.line_vertex[this.line_vertex.length - 1] = clone;
          this.vertexes = this.vertexes.reverse();

          this._applyVertexes();
        }

        setPoints() {
          for (var i = 0; i < this.colliderPoints.length; i++) {
            var colliderPointsI = this.colliderPoints[i];
            colliderPointsI.push(v2(colliderPointsI[colliderPointsI.length - 1].x, this.min_width));
            colliderPointsI.push(v2(colliderPointsI[0].x, this.min_width));
            colliderPointsI = colliderPointsI.reverse();
          }

          log('顶点');
          log(this.colliderPoints);

          for (var _i2 = 0; _i2 < this.colliderPoints.length; _i2++) {
            var nowCollider = this.colliderParent.children[_i2];
            var polygon = nowCollider.getComponent(PolygonCollider2D);
            polygon.points = this.colliderPoints[_i2];
            polygon.apply();
          }
        }

        _generateSegmentVertex(seg_count) {
          this._line_vertex_segment.length = 0;
          this.colliderPoints.length = 0;
          var dynamic_seg = seg_count;

          for (var i = 0; i < this.line_vertex.length - 1; i++) {
            var p1 = this.line_vertex[i];
            var p2 = this.line_vertex[i + 1];
            var cloneP1 = this.line_vertex[i].clone();
            var cloneP2 = this.line_vertex[i + 1].clone();
            var p3 = p1.add(p2).multiplyScalar(0.5);
            this.line_vertex[i] = cloneP1;
            p1 = this.line_vertex[i];
            var para1 = 2 * 3.1415926 / (2 * (p2.x - p1.x));
            var para2 = p2.y - p3.y;
            dynamic_seg = seg_count;

            if (Math.abs(p1.y - p2.y) < 80) {
              dynamic_seg = 4;
            }

            var gap = p2.subtract(p1).multiplyScalar(1 / dynamic_seg);
            var gapClone = gap.clone();
            this.line_vertex[i + 1] = cloneP2;
            p2 = this.line_vertex[i + 1];

            this._line_vertex_segment.push(p1);

            var idx = this._line_vertex_segment.length - 1;

            var arrayClone = this._line_vertex_segment[idx].clone();

            var array = [];
            array.push(v2(p1.x + this.offSet.x, p1.y + this.offSet.y));

            for (var index = 0; index < dynamic_seg - 1; index++) {
              cloneP1 = this.line_vertex[i].clone();
              var gap1 = gapClone.clone();
              var t = p1.add(gap1.multiplyScalar(index + 1));
              this.line_vertex[i] = cloneP1;
              p1 = this.line_vertex[i];
              var t_local = t.subtract(p3);
              t_local.y = Math.sin(para1 * t_local.x) * para2;
              var t_result = t_local.add(p3);

              this._line_vertex_segment.push(t_result);

              this._line_vertex_segment[idx] = arrayClone;
              array.push(v2(t_result.x + this.offSet.x, t_result.y + this.offSet.y));
            }

            array.push(v2(p2.x + this.offSet.x, p2.y + this.offSet.y));
            this.colliderPoints.push(array);
          }

          this._line_vertex_segment.push(this.line_vertex[this.line_vertex.length - 1]);
        }

        calculationMin() {
          this.min_width = 0;

          for (var i = 0; i < this.vertexes.length - 1; i++) {
            if (this.vertexes[i].y < this.min_width) {
              this.min_width = this.vertexes[i].y;
            }
          }
        }

      }, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "spriteFrame", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "material", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "movePoint", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "terrainCollider", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "line_vertex", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [v3(0, 200, 0), v3(200, 200, 0), v3(400, 200, 0), v3(600, 200, 0)];
        }
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "vertexes", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [v3(0, 0), v3(0, 100), v3(100, 100), v3(100, 0)];
        }
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "offSet", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return new Vec2();
        }
      })), _class2)) || _class) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=terrain.js.map