import { Component, Rect, SpriteFrame, SpriteRenderer, _decorator, rect } from "cc";
const { ccclass, property, executeInEditMode, executionOrder, requireComponent } = _decorator;

@ccclass
@requireComponent(SpriteRenderer)
@executeInEditMode
export class SpriteRenderRect extends Component {
    @property({ serializable: true })
    private _spriteFrame: SpriteFrame | null = null;

    @property({ serializable: true })
    private _spriteFrameRect: Rect = rect();

    @property(SpriteFrame)
    get spriteFrame(): SpriteFrame | null {
        return this._spriteFrame;
    }
    set spriteFrame(value: SpriteFrame | null) {
        if (this._spriteFrame == value) {
            return;
        }
        this._spriteFrame = value;
        if (this._spriteFrame) {
            this._spriteFrameRect.x = 0;
            this._spriteFrameRect.y = 0;
            this._spriteFrameRect.width = this._spriteFrame.texture.width;
            this._spriteFrameRect.height = this._spriteFrame.texture.height;
        }
        this._updateRender();
    }

    @property(Rect)
    get spriteFrameRect(): Rect | null {
        return this._spriteFrameRect;
    }
    set spriteFrameRect(value: Rect) {
        if (this._spriteFrameRect == value) {
            return;
        }
        if (!value) {
            this._updateRender();
            return;
        }

        let dirty = false;
        if (this._spriteFrameRect.x != value.x) {
            this.spriteFrameRect.x = value.x;
            dirty = true;
        }
        if (this._spriteFrameRect.y != value.y) {
            this.spriteFrameRect.y = value.y;
            dirty = true;
        }
        if (this._spriteFrameRect.width != value.width) {
            this.spriteFrameRect.width = value.width;
            dirty = true;
        }
        if (this._spriteFrameRect.height != value.height) {
            this.spriteFrameRect.height = value.height;
            dirty = true;
        }
        if (dirty) {
            this._updateRender();
        }
    }

    protected onEnable(): void {
        this._updateRender();
    }

    private _updateRender() {
        const spriteRender = this.getComponent(SpriteRenderer)!;
        if (this.spriteFrame == null) {
            spriteRender.spriteFrame = null;
        } else {
            const cloneSpriteFrame = this.spriteFrame.clone();
            cloneSpriteFrame.rect = this.spriteFrameRect;
            spriteRender.spriteFrame = cloneSpriteFrame;
        }
    }
}
