
import { _decorator, Component, Node, find, Vec3, ParticleSystem } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Typescript001')
export class Typescript001 extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    private playing = false;

    start() {
        // [3]
        this.node.on("click", this.show, this);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }

    show() {
        // 请间隔2.5秒以上点击按钮，让粒子跑完生命周期
        if (this.playing) return;

        let node = find("Parent/Cube");
        let particle = find("Parent/Cube/Particle")!.getComponent(ParticleSystem);

        node!.setPosition(new Vec3(0, 0, -5 + Math.random() * 10));

        particle!.enabled = true;

        this.scheduleOnce(() => {
            particle!.play();
        }, 0.5);

        particle!.play();
        this.playing = true;

        this.scheduleOnce(() => {
            particle!.stop();
            particle!.clear();
            particle!.enabled = false;
            this.playing = false;
        }, 2.5);
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
