
import { _decorator, Component, Node, ParticleSystem, CCLoader, NodePool, Prefab, instantiate, resources, find, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Typescript')
export class Typescript extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    _pools: any = {};

    start() {
        // // [3]
        // this.particle!.play();

        // this.scheduleOnce(() => {

        //     this.particle!.stop();
        //     this.particle!.node.active = false;
        // }, 0.5);

        // this.scheduleOnce(() => {
        //     this.particle!.node.active = true;
        //     this.particle!.play();

        //     console.log("play")
        // }, 1);

        this.node.on("click", this.show, this);
    }

    show() {
        this.get("Particle", (node) => {
            node!.setParent(find("Parent"));
            node!.setPosition(Vec3.ZERO);
            
            this.playParticle(node!);
        });
    }

    async playParticle(node: Node) {
        node!.getComponent(ParticleSystem)!.play();
        await new Promise<void>(resolve => { this.scheduleOnce(() => { resolve(); }, 0.5) });
        node!.getComponent(ParticleSystem)!.stop();
        this.put(node);
    }

    _getPoolName(path: string) {
        return path;
    }

    _createNode(uniqPoolName: string, prefab: Prefab): Node {
        let node: any = instantiate(prefab);
        node["__wgPoolName"] = uniqPoolName;
        return node;
    }

    _ensureGetPool(poolName: string) {
        if (!this._pools[poolName]) {
            this._pools[poolName] = new NodePool();
        }
        return this._pools[poolName];
    }

    get(path: string, handler: (node: Node | null) => void) {
        let poolName = this._getPoolName(path);
        let pool = this._ensureGetPool(poolName);
        if (pool.size() > 0) {
            handler(pool.get());
            return;
        }


        console.log("Get new ", path);
        this.load(path, Prefab, (prefab: any) => {
            if (!prefab) {
                handler(null);
                return;
            }
            let node = this._createNode(poolName, prefab);
            handler(node);
        });
    }

    put(node: Node, maxSize: number = 128) {
        let poolName = (<any>node)['__wgPoolName'];
        if (!poolName) {
            return;
        }
        let pool = this._ensureGetPool(poolName);
        if (pool.size() >= maxSize) {
        } else {
            pool.put(node);
        }
    }

    load(path: any, type: any, onComplete: (asset: any) => void, onProgress?: (finish: number, total: number, item: any) => void) {
        resources.load(path, type, onProgress as any, (error, asset) => {
            if (error) {
                onComplete(null);
                return;
            }
            onComplete(asset);
        });
    }
}
