import { Component, ImageAsset, Sprite, SpriteFrame, Texture2D, _decorator, assetManager } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    @property({ type: Sprite })
    public avatarSprite: Sprite = null;

    start() {
        this.getAvatarUrl();
    }
    //获取用户网络头像
    getAvatarUrl() {
        let imgUrl1 = "https://wx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTJ2Bj7t2y8ia1FVXH5rjLw4Zg7QxY5Q5pXlQ1WibLZJz2Z5kZM6QXQXh9n2a9wYJ0yJ7k7q1yib2G5WQ/132"
        let url = "https://dev-img.lovechatbar.com/image/lpj4zvg97cefb19d927689254ae942ff0b5bf6a5.png"
        // url = "http://pic21.photophoto.cn/20111106/0020032891433708_b.jpg"
        url = "https://dev-img.lovechatbar.com/image/male-avatar222.jpeg"
        assetManager.loadRemote<ImageAsset>(url, (err, imageAsset) => {
            if (err) {
                console.error(err);
                return;
            }
            const spriteFrame = new SpriteFrame();
            const texture = new Texture2D();
            texture.image = imageAsset;
            spriteFrame.texture = texture;
            this.avatarSprite.spriteFrame = spriteFrame;
            assetManager.cacheManager
        });
    }

}