"use strict";
cc._RF.push(module, '3a7cf3wDPxAM5oWbI8zEfgo', 'game');
// srcipt/game.js

"use strict";

// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
cc.Class({
  "extends": cc.Component,
  properties: {
    tiledMap: cc.TiledMap // foo: {
    //     // ATTRIBUTES:
    //     default: null,        // The default value will be used only when the component attaching
    //                           // to a node for the first time
    //     type: cc.SpriteFrame, // optional, default is typeof default
    //     serializable: true,   // optional, default is true
    // },
    // bar: {
    //     get () {
    //         return this._bar;
    //     },
    //     set (value) {
    //         this._bar = value;
    //     }
    // },

  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //   开启物理引擎
    var p = cc.director.getPhysicsManager();
    p.enabled = true; // 碰撞局域的描绘

    p.debugDrawFlags = true;
    p.gravity = cc.v2(0, 0);
  },
  start: function start() {
    // let tiledMap = this.mapNode.getComponent(cc.TiledMap);
    // console.log(tiledMap);
    // 每一小块的距离
    var tiledSize = this.tiledMap.getTileSize(); //   拿到wall城墙
    // console.log(tiledSize);

    var layer = this.tiledMap.getLayer("wall"); // 拿到块数

    console.log(layer);
    var layerSize = layer.getLayerSize(); // console.log(layerSize);
    // 迷雾
    // let smogLayer = tiledMap.getLayer("smog");
    // smogLayer.node.active = true;
    // console.log(layerSize.width);

    for (var i = 0; i < layerSize.width; i++) {
      for (var j = 0; j < layerSize.height; j++) {
        // console.log(layer);
        var tiled = layer.getTiledTileAt(i, j, true);

        if (tiled.gid != 0) {
          tiled.node.group = "wall";
          var body = tiled.node.addComponent(cc.RigidBody);
          body.type = cc.RigidBodyType.Static;
          var collider = tiled.node.addComponent(cc.PhysicsBoxCollider);
          collider.offset = cc.v2(tiledSize.width / 2, tiledSize.height / 2);
          collider.size = tiledSize;
          collider.apply();
        }
      }
    }
  } // update (dt) {},

});

cc._RF.pop();