import { _decorator, Component, EventMouse, Input, input, KeyCode, Node } from 'cc';
const { ccclass } = _decorator;

@ccclass('InputBug')
export class InputBug extends Component {
  protected onEnable(): void {
    input.on(Input.EventType.KEY_DOWN, (event) => {
      console.log(`keydown: ${KeyCode[event.keyCode]}`);
    });
    input.on(Input.EventType.KEY_UP, (event) => {
      console.log(`keyup: ${KeyCode[event.keyCode]}`);
    });
    this.node.on(Node.EventType.MOUSE_DOWN, (event: EventMouse) => {
      console.log(`mousedown: ${event.getButton()}`);
    });
    this.node.on(Node.EventType.MOUSE_UP, (event) => {
      console.log(`mouseup: ${event.getButton()}`);
    });
  }
}


