// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;
import { Quadtree } from "./QuadTree";

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Prefab)
    nodePrefab: cc.Prefab = null;
    @property(cc.Label)
    btnTreeLabel: cc.Label = null;
    private openQuadTree: boolean = false

    private nodes: Array<cc.Node> = [];
    private tree: Quadtree = null;

    start() {
        var bounds = {
            x: 0,
            y: 0,
            width: cc.Canvas.instance.node.width,
            height: cc.Canvas.instance.node.height
        }
        this.tree = new Quadtree(bounds);

        for (let i = 0; i < 300; i++) {
            let newNode = cc.instantiate(this.nodePrefab);
            this.node.addChild(newNode);
            this.nodes.push(newNode)
            this.tree.insert(newNode);
        }
        this.btnTreeLabel.string = this.openQuadTree ? "关闭四叉树" : "开启四叉树"

    }
    clickBtnTree() {
        this.openQuadTree = !this.openQuadTree
        this.btnTreeLabel.string = this.openQuadTree ? "关闭四叉树" : "开启四叉树"
    }
    /**
     * 四叉树碰撞检测
     */
    quadTreeCheck() {
        for (let node of this.nodes) {
            node.getComponent("Node").setIsCollision(false)
            this.tree.insert(node);
        }
        for (let i = 0; i < this.nodes.length; i++) {
            let node = this.nodes[i]
            let targetNodes = this.tree.retrieve(node)
            for (let j = 0; j < targetNodes.length; j++) {
                let targetNode = targetNodes[j]
                if (targetNode === node) continue
                let isCollision: any = targetNode.getBoundingBoxToWorld().intersects(node.getBoundingBoxToWorld())
                if (isCollision) {
                    node.getComponent("Node").setIsCollision(isCollision)
                    targetNode.getComponent("Node").setIsCollision(isCollision)
                }

            }
        }
        this.tree.clear()

    }
    /**
     * 普通碰撞检测
     */
    normalCheck() {
        for (let node of this.nodes) {
            node.getComponent("Node").setIsCollision(false)
        }
        for (let i = 0; i < this.nodes.length; i++) {
            let node = this.nodes[i]

            for (let j = 0; j < this.nodes.length; j++) {
                let targetNode = this.nodes[j]
                if (targetNode === node) continue
                let isCollision: any = targetNode.getBoundingBoxToWorld().intersects(node.getBoundingBoxToWorld())
                if (isCollision) {
                    node.getComponent("Node").setIsCollision(isCollision)
                    targetNode.getComponent("Node").setIsCollision(isCollision)
                }

            }
        }
    }

    update(dt) {
        if(this.openQuadTree){
            this.quadTreeCheck()
        }else{
            this.normalCheck()
        }
    }


}
