// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}
    public isCollision: boolean = false;
    private speedX = 3;
    private speedY = 3;
    start() {
        this.speedX *= Math.random() > 0.5 ? -1 : 1
        this.speedY *= Math.random() > 0.5 ? -1 : 1
        this.node.x = Math.random() * cc.Canvas.instance.node.width ;
        this.node.y = Math.random() * cc.Canvas.instance.node.height ;

    }

    update(dt) {
        let speed = 3;
        this.node.x += Math.random() * speed;
        this.node.y +=  Math.random() * speed;
        this.move();
    }
    move() {
        let wd = cc.winSize.width ;
        let ht = cc.winSize.height ;
        let x = this.node.x + this.speedX
        if (x <  this.node.width * 0.5 || x > wd - this.node.width * 0.5) {
            this.speedX *= -1
        }
        this.node.x += this.speedX
        let y = this.node.y + this.speedY
        if (y <  this.node.height * 0.5 || y > ht - this.node.height * 0.5) {
            this.speedY *= -1
        }
        this.node.y += this.speedY

    }

    public setIsCollision(isCollision) {
        this.isCollision = isCollision;
        if (isCollision) {
            this.node.color = cc.color(255, 0, 0);
        } else {
            this.node.color = cc.color(255, 255, 255);
        }
    }
}
