
import { Component, _decorator, Node, Prefab, instantiate, PhysicsSystem, Vec3, UICoordinateTrackerComponent, EventHandler, EventTouch, SpriteComponent, Sprite, SpriteFrame, Camera } from "cc";
import { IArea, ICountry, IMap, IPlayer } from "../../../shared/gameClient/games/OccupationTheWarModels";
import { OTWAreaData } from "../Data/OTWAreaData";
import { OTWGameData } from "../Data/OTWGameData";
import { OTWFlagComponent } from "./OTWFlagComponent";
const { ccclass, property } = _decorator;

@ccclass('OTWAreaFlagComponent')
export class OTWAreaFlagComponent extends OTWFlagComponent {
    areaInfo: OTWAreaData | null = null;

    onDestroy() {
        this.areaInfo = null;
    }

    public updateShow() {
        if (!this.areaInfo) return;
        super.updateShow();
        var area = this.getGameData().map?.allArea[this.areaInfo.area.areaIndex];
        if (area) {
            this.Text.string += ` ${area.troopsCurr}`;
        }
    }
}