
import { _decorator, Component, Node, Prefab, Camera, instantiate, Collider, CollisionEventType, ITriggerEvent, Vec3, v3, Quat } from 'cc';
import { IArea, ITroop, IMap, ICountry } from '../../../shared/gameClient/games/OccupationTheWarModels';
import { PHY_GROUP } from '../Const';
import { OTWTroopFlagComponent } from './OTWTroopFlagComponent';
import { OTWTroopData } from '../Data/OTWTroopData';
import { OTWTroopRenderComponent } from './OTWTroopRenderComponent';
import { OTWObjectComponent } from './OTWObjectComponent';
import { OTWGameData } from '../Data/OTWGameData';
import { OTWFlagComponent } from './OTWFlagComponent';
const { ccclass, property } = _decorator;

@ccclass('OTWTroopComponent')
export class OTWTroopComponent extends OTWObjectComponent {
    public troopInfo: OTWTroopData | null = null;

    /**移动速度,每秒距离*/
    private moveSpeed: number = 1;

    private isMoving = false;
    private moveFrom: Vec3 = v3();
    private moveTo: Vec3 = v3();
    private distance: number = 0;
    private useSec: number = 0;
    private goSec: number = 0;

    private tmpPos: Vec3 = v3();

    onDestroy() {
        this.troopInfo = null;
    }

    public setMove(targetX: number, targetZ: number) {
        this.moveFrom.set(this.troopInfo!.troop.x, 0, this.troopInfo!.troop.z);
        this.moveTo.set(targetX, 0, targetZ);
        this.distance = Vec3.distance(this.moveFrom, this.moveTo);
        this.useSec = this.distance / this.moveSpeed;
        this.node.lookAt(this.moveTo);
        this.goSec = 0;
        this.isMoving = true;
    }

    start() {
        var collider = this.getComponentInChildren(Collider);
        collider?.setGroup(PHY_GROUP.Troop);
        collider?.setMask(0xffffffff);
    }

    public updateData(dt: number) {
        if (!this.troopInfo) return;
        if (this.isMoving) {
            this.goSec += dt;
            if (this.goSec > this.useSec) {
                //时间到,直接设为目标值
                this.isMoving = false;
                //this.tmpPos.set(this.moveTo);
                //this._result.currIsTarget = true;
                this.node.setPosition(this.moveTo);
            } else {
                //中间用线性差值
                Vec3.lerp(this.tmpPos, this.moveFrom, this.moveTo, this.goSec / this.useSec);
                this.node.setPosition(this.tmpPos);
            }
            this.troopInfo.troop.x = this.node.position.x;
            this.troopInfo.troop.z = this.node.position.z;
            console.log('Troop.updateData', this.node.position);
        }
    }

    public static createNode(troopPrefab: Prefab, troopColliderPrefab: Prefab, troopFlagPrefab: Prefab,
        getGameData: () => OTWGameData, troop: ITroop, country: ICountry | null, mainCamera: Camera, gameMgrNode: Node,
        gameFlagUIWrapNode: Node, gameObjWrapNode: Node): OTWTroopData {

        var renderNode = instantiate(troopPrefab);
        renderNode.name = "TroopRender_" + troop.troopIndex;

        let flagComp!: OTWTroopFlagComponent;
        var flagNode = OTWFlagComponent.createFlagNode(OTWTroopFlagComponent, getGameData, troopFlagPrefab, renderNode,
            mainCamera, gameMgrNode, "OTWGameManager", "onTroopFlagUIUpdate", troop.troopIndex.toString(), country, (c) => {
                flagComp = c;
            });
        gameFlagUIWrapNode.addChild(flagNode);

        var renderComp = renderNode.getComponent(OTWTroopRenderComponent)!;

        renderNode.setPosition(troop.x, 0, troop.z);
        gameObjWrapNode.addChild(renderNode);

        var troopNode = instantiate(troopColliderPrefab);
        troopNode.name = "Troop_" + troop.troopIndex;
        var troopComp = troopNode.getComponent(OTWTroopComponent)!;

        troopNode.setPosition(troop.x, 0, troop.z);
        gameObjWrapNode.addChild(troopNode);

        var troopInfo: OTWTroopData = {
            troop: troop,
            fromArea: getGameData().allAreaInfo[troop.fromAreaIndex].area,
            toArea: getGameData().allAreaInfo[troop.toAreaIndex].area,
            country: country,
            renderNode: renderNode,
            renderComp: renderComp,
            troopNode: troopNode,
            troopComp: troopComp,
            flagNode: flagNode,
            flagComp: flagComp,
        };
        renderComp.troopInfo = troopInfo;
        renderComp.getGameData = getGameData;
        flagComp.troopInfo = troopInfo;
        flagComp.getGameData = getGameData;
        troopComp.troopInfo = troopInfo;
        troopComp.getGameData = getGameData;
        troopComp.setMove(troopInfo.toArea.x, troopInfo.toArea.z);

        flagComp.updateShow();

        return troopInfo;

    }
}
