
import { Component, _decorator, Node, Prefab, instantiate, PhysicsSystem, Vec3, UICoordinateTrackerComponent, EventHandler, EventTouch, SpriteComponent, Sprite, SpriteFrame, Camera } from "cc";
import { IArea, ICountry, IMap, IPlayer, ITroop } from "../../../shared/gameClient/games/OccupationTheWarModels";
import { OTWGameData } from "../Data/OTWGameData";
import { OTWTroopData } from "../Data/OTWTroopData";
import { OTWFlagComponent } from "./OTWFlagComponent";
const { ccclass, property } = _decorator;

@ccclass('OTWTroopFlagComponent')
export class OTWTroopFlagComponent extends OTWFlagComponent {

    troopInfo: OTWTroopData | null = null;

    onDestroy() {
        this.troopInfo = null;
    }

    public updateShow() {
        if (!this.troopInfo) return;
        var troop = this.getGameData().map?.allAttackingTroop[this.troopInfo.troop.troopIndex];
        if(troop){
            this.Text.string = ` ${troop.troopsCount}`;
        }
    }
}