System.register(["__unresolved_0", "cc"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, Component, _decorator, SpriteComponent, Node, geometry, v2, Quat, Vec3, _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _temp, _crd, ccclass, property, OTWGameTouchController;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  function _reportPossibleCrUseOfOTWSceneManager(extras) {
    _reporterNs.report("OTWSceneManager", "./OTWSceneManager", _context.meta, extras);
  }

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      Component = _cc.Component;
      _decorator = _cc._decorator;
      SpriteComponent = _cc.SpriteComponent;
      Node = _cc.Node;
      geometry = _cc.geometry;
      v2 = _cc.v2;
      Quat = _cc.Quat;
      Vec3 = _cc.Vec3;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "8d587+uoppG/5X5jAUjKhFr", "OTWGameTouchController", undefined);

      ({
        ccclass,
        property
      } = _decorator);

      _export("OTWGameTouchController", OTWGameTouchController = (_dec = ccclass('OTWGameTouchController'), _dec2 = property({
        type: Node,
        tooltip: "捕获游戏手势操作的节点,尽量全屏的节点,但要放在UI节点之下"
      }), _dec3 = property({
        type: SpriteComponent,
        tooltip: "攻击选择来源"
      }), _dec4 = property({
        type: SpriteComponent,
        tooltip: "攻击选择目标"
      }), _dec5 = property({
        type: SpriteComponent,
        tooltip: "攻击选择箭头"
      }), _dec(_class = (_class2 = (_temp = class OTWGameTouchController extends Component {
        constructor(...args) {
          super(...args);

          _initializerDefineProperty(this, "GameTouchCaption", _descriptor, this);

          _initializerDefineProperty(this, "AttackFrom", _descriptor2, this);

          _initializerDefineProperty(this, "AttackTo", _descriptor3, this);

          _initializerDefineProperty(this, "AttackArrow", _descriptor4, this);

          _defineProperty(this, "touchRayGetObjHandler", void 0);

          _defineProperty(this, "touchFromToHandler", void 0);

          _defineProperty(this, "tmpRay", new geometry.Ray());

          _defineProperty(this, "fromNode", null);

          _defineProperty(this, "toNode", null);

          _defineProperty(this, "arrowDefDir", v2(1, 0));

          _defineProperty(this, "arrowTmpDir", v2(0, 0));

          _defineProperty(this, "arrowQuat", new Quat());

          _defineProperty(this, "arrowScale", new Vec3(1, 1, 1));
        }

        start() {
          var _this$GameTouchCaptio, _this$GameTouchCaptio2, _this$GameTouchCaptio3, _this$GameTouchCaptio4;

          (_this$GameTouchCaptio = this.GameTouchCaption) === null || _this$GameTouchCaptio === void 0 ? void 0 : _this$GameTouchCaptio.on(Node.EventType.TOUCH_START, this.onGameTouchStart, this);
          (_this$GameTouchCaptio2 = this.GameTouchCaption) === null || _this$GameTouchCaptio2 === void 0 ? void 0 : _this$GameTouchCaptio2.on(Node.EventType.TOUCH_MOVE, this.onGameTouchMove, this);
          (_this$GameTouchCaptio3 = this.GameTouchCaption) === null || _this$GameTouchCaptio3 === void 0 ? void 0 : _this$GameTouchCaptio3.on(Node.EventType.TOUCH_END, this.onGameTouchEnd, this);
          (_this$GameTouchCaptio4 = this.GameTouchCaption) === null || _this$GameTouchCaptio4 === void 0 ? void 0 : _this$GameTouchCaptio4.on(Node.EventType.TOUCH_CANCEL, this.onGameTouchCancel, this);
          this.AttackFrom.node.setPosition(-999, -999, -999);
          this.AttackTo.node.setPosition(-999, -999, -999);
          this.AttackArrow.node.setPosition(-999, -999, -999);
        }

        onGameTouchStart(ev) {
          var _this$sceneMgr$MainCa, _this$touchRayGetObjH;

          this.fromNode = null;
          this.AttackFrom.node.setPosition(-999, -999, -999);

          if (ev.getAllTouches().length > 1) {
            //两个手指操作就取消
            return;
          }

          const touch = ev.touch;
          var uiX = touch.getUILocationX();
          var uiY = touch.getUILocationY();
          (_this$sceneMgr$MainCa = this.sceneMgr.MainCamera) === null || _this$sceneMgr$MainCa === void 0 ? void 0 : _this$sceneMgr$MainCa.screenPointToRay(touch.getLocationX(), touch.getLocationY(), this.tmpRay);
          var node = (_this$touchRayGetObjH = this.touchRayGetObjHandler) === null || _this$touchRayGetObjH === void 0 ? void 0 : _this$touchRayGetObjH.call(this, true, this.tmpRay);
          if (!node) return;
          this.fromNode = node;
          this.AttackFrom.node.setPosition(uiX, uiY, 0);
          this.AttackArrow.node.setPosition(uiX, uiY, 0);
          this.arrowScale.x = 1;
          this.AttackArrow.node.setScale(this.arrowScale);
        }

        onGameTouchMove(ev) {
          var _this$sceneMgr$MainCa2, _this$touchRayGetObjH2;

          if (!this.fromNode) return;
          this.toNode = null;
          this.AttackTo.node.setPosition(-999, -999, -999);
          const touch = ev.touch;
          var uiX = touch.getUILocationX();
          var uiY = touch.getUILocationY();
          var dirX = uiX - this.AttackArrow.node.position.x;
          var dirY = uiY - this.AttackArrow.node.position.y; //更新箭头指向

          this.arrowTmpDir.x = dirX;
          this.arrowTmpDir.y = dirY;
          this.arrowTmpDir.normalize();
          var angle = this.arrowDefDir.signAngle(this.arrowTmpDir);
          Quat.fromAxisAngle(this.arrowQuat, Vec3.UNIT_Z, angle);
          this.AttackArrow.node.setRotation(this.arrowQuat);
          var dis = Math.sqrt(dirX * dirX + dirY * dirY);
          var mu = dis / 30;
          this.arrowScale.x = mu;
          this.AttackArrow.node.setScale(this.arrowScale);
          (_this$sceneMgr$MainCa2 = this.sceneMgr.MainCamera) === null || _this$sceneMgr$MainCa2 === void 0 ? void 0 : _this$sceneMgr$MainCa2.screenPointToRay(touch.getLocationX(), touch.getLocationY(), this.tmpRay);
          var node = (_this$touchRayGetObjH2 = this.touchRayGetObjHandler) === null || _this$touchRayGetObjH2 === void 0 ? void 0 : _this$touchRayGetObjH2.call(this, false, this.tmpRay);
          if (!node || node == this.fromNode) return;
          this.toNode = node;
          this.AttackTo.node.setPosition(uiX, uiY, 0);
        }

        onGameTouchEnd(ev) {
          var _this$touchFromToHand;

          if (!this.fromNode || !this.toNode) {
            this.onGameTouchCancel(ev);
            return;
          }

          var f = this.fromNode;
          var t = this.toNode;
          this.onGameTouchCancel(ev);
          (_this$touchFromToHand = this.touchFromToHandler) === null || _this$touchFromToHand === void 0 ? void 0 : _this$touchFromToHand.call(this, f, t);
        }

        onGameTouchCancel(ev) {
          this.fromNode = null;
          this.AttackFrom.node.setPosition(-999, -999, -999);
          this.toNode = null;
          this.AttackTo.node.setPosition(-999, -999, -999);
          this.AttackArrow.node.setPosition(-999, -999, -999);
        }

      }, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "GameTouchCaption", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "AttackFrom", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "AttackTo", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "AttackArrow", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=OTWGameTouchController.js.map