System.register(["__unresolved_0", "cc", "__unresolved_1", "__unresolved_2", "__unresolved_3", "__unresolved_4"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, gameServiceProto, AWsClient, logger, Result, GameClient, _crd;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _reportPossibleCrUseOfBaseWsClient(extras) {
    _reporterNs.report("BaseWsClient", "tsrpc-base-client", _context.meta, extras);
  }

  function _reportPossibleCrUseOfBaseWsClientOptions(extras) {
    _reporterNs.report("BaseWsClientOptions", "tsrpc-base-client", _context.meta, extras);
  }

  function _reportPossibleCrUseOfServiceProto(extras) {
    _reporterNs.report("ServiceProto", "tsrpc-proto", _context.meta, extras);
  }

  function _reportPossibleCrUseOfgameServiceProto(extras) {
    _reporterNs.report("gameServiceProto", "./protocols/serviceProto", _context.meta, extras);
  }

  function _reportPossibleCrUseOfgameServiceType(extras) {
    _reporterNs.report("gameServiceType", "./protocols/serviceProto", _context.meta, extras);
  }

  function _reportPossibleCrUseOfAWsClient(extras) {
    _reporterNs.report("AWsClient", "../tsgf/AClient", _context.meta, extras);
  }

  function _reportPossibleCrUseOflogger(extras) {
    _reporterNs.report("logger", "../tsgf/logger", _context.meta, extras);
  }

  function _reportPossibleCrUseOfResult(extras) {
    _reporterNs.report("Result", "../tsgf/Result", _context.meta, extras);
  }

  _export("GameClient", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
    }, function (_unresolved_2) {
      gameServiceProto = _unresolved_2.serviceProto;
    }, function (_unresolved_3) {
      AWsClient = _unresolved_3.AWsClient;
    }, function (_unresolved_4) {
      logger = _unresolved_4.logger;
    }, function (_unresolved_5) {
      Result = _unresolved_5.Result;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "549e4Irjc1OvrC4WbwubGQn", "gameClient", undefined);

      _export("GameClient", GameClient = class GameClient extends (_crd && AWsClient === void 0 ? (_reportPossibleCrUseOfAWsClient({
        error: Error()
      }), AWsClient) : AWsClient) {
        constructor(buildClient, serverUrl) {
          super(buildClient, _crd && gameServiceProto === void 0 ? (_reportPossibleCrUseOfgameServiceProto({
            error: Error()
          }), gameServiceProto) : gameServiceProto, {
            server: serverUrl,
            json: false,
            logger: _crd && logger === void 0 ? (_reportPossibleCrUseOflogger({
              error: Error()
            }), logger) : logger
          });

          _defineProperty(this, "connectionId", void 0);

          _defineProperty(this, "reconnectWaitSec", 2);

          _defineProperty(this, "reconnectTimerHD", void 0);

          _defineProperty(this, "disconnectHandler", void 0);

          _defineProperty(this, "onReconnectResult", void 0);

          this.connectionId = ""; //设置断线重连的中间件

          this.client.flows.postDisconnectFlow.push(async v => {
            var _this$disconnectHandl;

            //如果都没连上过就断开,那么忽略
            if (!this.connectionId) return v; //判断是否需要重连

            if (!v.isManual && ((_this$disconnectHandl = this.disconnectHandler) === null || _this$disconnectHandl === void 0 ? void 0 : _this$disconnectHandl.call(this))) {
              var _this$client$logger;

              (_this$client$logger = this.client.logger) === null || _this$client$logger === void 0 ? void 0 : _this$client$logger.error('连接已断开,等待' + this.reconnectWaitSec + '秒后自动重连');
              if (this.reconnectTimerHD) clearTimeout(this.reconnectTimerHD);
              this.reconnectTimerHD = setTimeout(async () => this.startReconnect(true), this.reconnectWaitSec * 1000);
            } else {
              var _this$client$logger2;

              (_this$client$logger2 = this.client.logger) === null || _this$client$logger2 === void 0 ? void 0 : _this$client$logger2.error('连接已断开');
            }

            return v;
          });
        }

        async disconnect() {
          this.connectionId = '';
          await this.client.disconnect();
          this.stopReconnect();
        }

        stopReconnect() {
          if (this.reconnectTimerHD) clearTimeout(this.reconnectTimerHD);
        }

        async startReconnect(failReTry = true) {
          var _this$disconnectHandl2;

          const result = await this.reconnect(); // 重连也错误，弹出错误提示

          if (result.succ) {
            var _this$client$logger3, _this$onReconnectResu;

            (_this$client$logger3 = this.client.logger) === null || _this$client$logger3 === void 0 ? void 0 : _this$client$logger3.log('重连成功!');
            (_this$onReconnectResu = this.onReconnectResult) === null || _this$onReconnectResu === void 0 ? void 0 : _this$onReconnectResu.call(this, true, null);
            return true;
          } //如果是逻辑拒绝则不需要重连


          if (!this.connectionId || result.code == 5001) failReTry = false;

          if (failReTry && ((_this$disconnectHandl2 = this.disconnectHandler) === null || _this$disconnectHandl2 === void 0 ? void 0 : _this$disconnectHandl2.call(this))) {
            var _this$client$logger4;

            (_this$client$logger4 = this.client.logger) === null || _this$client$logger4 === void 0 ? void 0 : _this$client$logger4.error('重连失败:' + result.err + ' ' + this.reconnectWaitSec + '秒后自动重连!');
            if (this.reconnectTimerHD) clearTimeout(this.reconnectTimerHD);
            this.reconnectTimerHD = setTimeout(() => this.startReconnect(failReTry), this.reconnectWaitSec * 1000);
          } else {
            var _this$client$logger5, _this$onReconnectResu2;

            (_this$client$logger5 = this.client.logger) === null || _this$client$logger5 === void 0 ? void 0 : _this$client$logger5.error('重连失败:' + result.err);
            this.disconnect();
            (_this$onReconnectResu2 = this.onReconnectResult) === null || _this$onReconnectResu2 === void 0 ? void 0 : _this$onReconnectResu2.call(this, false, result.err);
          }

          return false;
        }
        /**
         * 使用临时分配的令牌登录
         * @param loginToken 
         * @returns  
         */


        async login(loginToken) {
          const connectRet = await this.client.connect();

          if (!connectRet.isSucc) {
            return "连接失败:" + connectRet.errMsg;
          }

          const loginRet = await this.client.callApi("Login", {
            loginToken: loginToken
          });

          if (!loginRet.isSucc) {
            this.disconnect();
            return loginRet.err.message;
          }

          this.connectionId = loginRet.res.connectionId;
          return null;
        }
        /**
         * 断线重连, 失败的话要看code,5001表示逻辑拒绝,不需要重连
         * @param loginToken 
         * @returns  
         */


        async reconnect() {
          const connectRet = await this.client.connect();

          if (!connectRet.isSucc) {
            return (_crd && Result === void 0 ? (_reportPossibleCrUseOfResult({
              error: Error()
            }), Result) : Result).buildErr("连接失败:" + connectRet.errMsg);
          }

          const loginRet = await this.client.callApi("Reconnect", {
            connectionId: this.connectionId
          });

          if (!loginRet.isSucc) {
            var _loginRet$err$code;

            const code = (_loginRet$err$code = loginRet.err.code) !== null && _loginRet$err$code !== void 0 ? _loginRet$err$code : 0;
            return (_crd && Result === void 0 ? (_reportPossibleCrUseOfResult({
              error: Error()
            }), Result) : Result).buildErr(loginRet.err.message, code);
          }

          this.connectionId = loginRet.res.connectionId;
          return (_crd && Result === void 0 ? (_reportPossibleCrUseOfResult({
            error: Error()
          }), Result) : Result).buildSucc(null);
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=gameClient.js.map