System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, BaseJoystick, _crd;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  _export("BaseJoystick", void 0);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "da220MAVxFDF6qxO4qpTING", "BaseJoystick", undefined);

      _export("BaseJoystick", BaseJoystick = class BaseJoystick {
        constructor() {
          _defineProperty(this, "moveHd", 0);

          _defineProperty(this, "startX", 0);

          _defineProperty(this, "startY", 0);

          _defineProperty(this, "moveX", 0);

          _defineProperty(this, "moveY", 0);

          _defineProperty(this, "lastMoveX", 0);

          _defineProperty(this, "lastMoveY", 0);

          _defineProperty(this, "backWidth", 0);

          _defineProperty(this, "backHeight", 0);

          _defineProperty(this, "handlerWidth", 0);

          _defineProperty(this, "handlerHeight", 0);

          _defineProperty(this, "handlerLeft", 0);

          _defineProperty(this, "handlerTop", 0);

          _defineProperty(this, "handlerCurrPos", {
            left: 0,
            top: 0
          });

          _defineProperty(this, "onmove", void 0);

          _defineProperty(this, "onmoveend", void 0);
        }

        /**
         * 初始化UI计算的尺寸, 如果不用计算的尺寸,可以不用初始化
         * @date 2022/2/23 - 下午1:56:34
         *
         * @public
         * @param {number} backSize
         * @param {number} handlerSize
         */
        initUISize(backSize, handlerSize) {
          this.backWidth = backSize;
          this.backHeight = backSize;
          this.handlerWidth = handlerSize;
          this.handlerHeight = handlerSize;
          this.handlerLeft = (this.backWidth - this.handlerWidth) / 2;
          this.handlerTop = (this.backHeight - this.handlerHeight) / 2;
        }

        touchStart(x, y) {
          this.startX = x;
          this.startY = y;
          this.moveX = this.moveY = this.lastMoveX = this.lastMoveY = 0;
          this.moveHd = setInterval(this.onCheckMove.bind(this), 30);
          return false;
        }

        touchMove(x, y) {
          var moveX = x - this.startX;
          var moveY = y - this.startY;
          var move = this.normalize(moveX, moveY);
          this.moveX = move.x;
          this.moveY = move.y;
          this.handlerCurrPos.left = this.handlerLeft + this.moveX * this.handlerLeft;
          this.handlerCurrPos.top = this.handlerTop + this.moveY * this.handlerTop;
          return this.handlerCurrPos;
        }

        touchEnd() {
          var _this$onmoveend;

          this.moveX = this.moveY = 0;
          this.handlerCurrPos.left = this.handlerLeft + this.moveX * this.handlerLeft;
          this.handlerCurrPos.top = this.handlerTop + this.moveY * this.handlerTop;
          clearInterval(this.moveHd);
          (_this$onmoveend = this.onmoveend) === null || _this$onmoveend === void 0 ? void 0 : _this$onmoveend.call(this);
          return this.handlerCurrPos;
        }

        onCheckMove() {
          if (this.moveX != 0 && this.moveY != 0 && (this.lastMoveX != this.moveX || this.lastMoveY != this.moveY)) {
            var _this$onmove;

            this.lastMoveX = this.moveX;
            this.lastMoveY = this.moveY;
            var dirX = this.moveX == 0 ? 0 : this.moveX > 0 ? 1 : -1;
            var dirZ = this.moveY == 0 ? 0 : this.moveY > 0 ? 1 : -1;
            var acuteRad = 0;

            if (dirX != 0 && dirZ != 0) {
              acuteRad = Math.atan(Math.abs(this.moveY / this.moveX));
            }

            (_this$onmove = this.onmove) === null || _this$onmove === void 0 ? void 0 : _this$onmove.call(this, {
              dirX,
              dirZ,
              acuteRad
            });
          }
        }

        normalize(x, y) {
          var len = Math.sqrt(x * x + y * y);
          var inv = len == 0 ? 0 : 1 / len;
          return {
            x: x * inv,
            y: y * inv
          };
        }

      });
      /**
       * 表示移动方向
       * @date 2022/2/21 - 下午1:43:43
       *
       * @export
       * @interface IMoveDirection
       * @typedef {IMoveDirection}
       */


      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=BaseJoystick.js.map