System.register(["__unresolved_0", "cc", "__unresolved_1", "__unresolved_2", "__unresolved_3", "__unresolved_4", "__unresolved_5", "__unresolved_6"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, FrameSyncExecutor, InputType, Component, _decorator, Node, Prefab, PhysicsSystem, Collider, OTWAreaComponent, OTWTroopComponent, PHY_GROUP, LinkMainNodeComponent, _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _temp, _crd, ccclass, property, OTWGameManager;

  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

  function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  function _reportPossibleCrUseOfOTWSceneManager(extras) {
    _reporterNs.report("OTWSceneManager", "./OTWSceneManager", _context.meta, extras);
  }

  function _reportPossibleCrUseOfFrameSyncExecutor(extras) {
    _reporterNs.report("FrameSyncExecutor", "../common/FrameSyncExecutor", _context.meta, extras);
  }

  function _reportPossibleCrUseOfConnectionInputOperate(extras) {
    _reporterNs.report("ConnectionInputOperate", "../../shared/gameClient/GameSyncFrame", _context.meta, extras);
  }

  function _reportPossibleCrUseOfIArea(extras) {
    _reporterNs.report("IArea", "../../shared/gameClient/games/OccupationTheWarModels", _context.meta, extras);
  }

  function _reportPossibleCrUseOfICountry(extras) {
    _reporterNs.report("ICountry", "../../shared/gameClient/games/OccupationTheWarModels", _context.meta, extras);
  }

  function _reportPossibleCrUseOfInputType(extras) {
    _reporterNs.report("InputType", "../../shared/gameClient/games/OccupationTheWarModels", _context.meta, extras);
  }

  function _reportPossibleCrUseOfIPlayer(extras) {
    _reporterNs.report("IPlayer", "../../shared/gameClient/games/OccupationTheWarModels", _context.meta, extras);
  }

  function _reportPossibleCrUseOfITroop(extras) {
    _reporterNs.report("ITroop", "../../shared/gameClient/games/OccupationTheWarModels", _context.meta, extras);
  }

  function _reportPossibleCrUseOfOTWAreaData(extras) {
    _reporterNs.report("OTWAreaData", "./Data/OTWAreaData", _context.meta, extras);
  }

  function _reportPossibleCrUseOfOTWAreaComponent(extras) {
    _reporterNs.report("OTWAreaComponent", "./Components/OTWAreaComponent", _context.meta, extras);
  }

  function _reportPossibleCrUseOfOTWTroopComponent(extras) {
    _reporterNs.report("OTWTroopComponent", "./Components/OTWTroopComponent", _context.meta, extras);
  }

  function _reportPossibleCrUseOfOTWTroopData(extras) {
    _reporterNs.report("OTWTroopData", "./Data/OTWTroopData", _context.meta, extras);
  }

  function _reportPossibleCrUseOfPHY_GROUP(extras) {
    _reporterNs.report("PHY_GROUP", "./Const", _context.meta, extras);
  }

  function _reportPossibleCrUseOfLinkMainNodeComponent(extras) {
    _reporterNs.report("LinkMainNodeComponent", "../common/LinkMainNodeComponent", _context.meta, extras);
  }

  function _reportPossibleCrUseOfOTWGameData(extras) {
    _reporterNs.report("OTWGameData", "./Data/OTWGameData", _context.meta, extras);
  }

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      Component = _cc.Component;
      _decorator = _cc._decorator;
      Node = _cc.Node;
      Prefab = _cc.Prefab;
      PhysicsSystem = _cc.PhysicsSystem;
      Collider = _cc.Collider;
    }, function (_unresolved_2) {
      FrameSyncExecutor = _unresolved_2.FrameSyncExecutor;
    }, function (_unresolved_3) {
      InputType = _unresolved_3.InputType;
    }, function (_unresolved_4) {
      OTWAreaComponent = _unresolved_4.OTWAreaComponent;
    }, function (_unresolved_5) {
      OTWTroopComponent = _unresolved_5.OTWTroopComponent;
    }, function (_unresolved_6) {
      PHY_GROUP = _unresolved_6.PHY_GROUP;
    }, function (_unresolved_7) {
      LinkMainNodeComponent = _unresolved_7.LinkMainNodeComponent;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "4f86fPuynVHOL8xkUSU4bQ9", "OTWGameManager", undefined);

      ({
        ccclass,
        property
      } = _decorator);

      _export("OTWGameManager", OTWGameManager = (_dec = ccclass('OTWGameManager'), _dec2 = property({
        type: Node,
        tooltip: "存放所有游戏对象的3D节点"
      }), _dec3 = property({
        type: Node,
        tooltip: "存放所有Flag的UI节点"
      }), _dec4 = property({
        type: Prefab,
        tooltip: "地域模型预制体"
      }), _dec5 = property({
        type: Prefab,
        tooltip: "地域旗帜UI的预制体"
      }), _dec6 = property({
        type: Prefab,
        tooltip: "士兵渲染模型预制体"
      }), _dec7 = property({
        type: Prefab,
        tooltip: "士兵碰撞体预制体"
      }), _dec8 = property({
        type: Prefab,
        tooltip: "士兵旗帜UI的预制体"
      }), _dec(_class = (_class2 = (_temp = class OTWGameManager extends Component {
        constructor() {
          super(...arguments);

          _initializerDefineProperty(this, "GameObjContainer", _descriptor, this);

          _initializerDefineProperty(this, "GameObjFlagUI", _descriptor2, this);

          _initializerDefineProperty(this, "AreaPrefab", _descriptor3, this);

          _initializerDefineProperty(this, "AreaFlagPrefab", _descriptor4, this);

          _initializerDefineProperty(this, "TroopRenderPrefab", _descriptor5, this);

          _initializerDefineProperty(this, "TroopColliderPrefab", _descriptor6, this);

          _initializerDefineProperty(this, "TroopFlagPrefab", _descriptor7, this);

          _defineProperty(this, "frameSyncExecutor", null);

          _defineProperty(this, "gameData", {
            map: null,
            allAreaInfo: [],
            allAttackingTroopInfo: [],
            myPlayer: null,
            myCountryId: null
          });

          _defineProperty(this, "getGameData", () => this.gameData);
        }

        start() {
          this.sceneMgr.TouchCtrl.touchRayGetObjHandler = (isFrom, ray) => {
            var _node$getComponent;

            if (!this.gameData.myPlayer) return null;

            if (!PhysicsSystem.instance.raycastClosest(ray, (_crd && PHY_GROUP === void 0 ? (_reportPossibleCrUseOfPHY_GROUP({
              error: Error()
            }), PHY_GROUP) : PHY_GROUP).Area)) {
              //没点到area节点,忽略
              return null;
            }

            var collider = PhysicsSystem.instance.raycastClosestResult.collider;
            var group = collider.getGroup();
            var node = collider.node;
            var mainNode = node === null || node === void 0 ? void 0 : (_node$getComponent = node.getComponent(_crd && LinkMainNodeComponent === void 0 ? (_reportPossibleCrUseOfLinkMainNodeComponent({
              error: Error()
            }), LinkMainNodeComponent) : LinkMainNodeComponent)) === null || _node$getComponent === void 0 ? void 0 : _node$getComponent.MainNode;
            var areaInfoComp = mainNode === null || mainNode === void 0 ? void 0 : mainNode.getComponent(_crd && OTWAreaComponent === void 0 ? (_reportPossibleCrUseOfOTWAreaComponent({
              error: Error()
            }), OTWAreaComponent) : OTWAreaComponent);
            if (!areaInfoComp) return null;

            if (isFrom) {
              if (this.gameData.myPlayer.countryId != areaInfoComp.areaInfo.area.countryId) {
                //不是自己国家的地域,不能操作!
                return null;
              }
            }

            return areaInfoComp.areaInfo.area;
          };

          this.sceneMgr.TouchCtrl.touchFromToHandler = (fromArea, toArea) => {
            var _this$frameSyncExecut;

            if (!fromArea || !toArea) {
              return;
            }

            (_this$frameSyncExecut = this.frameSyncExecutor) === null || _this$frameSyncExecut === void 0 ? void 0 : _this$frameSyncExecut.sendInputFrame({
              inputType: (_crd && InputType === void 0 ? (_reportPossibleCrUseOfInputType({
                error: Error()
              }), InputType) : InputType).Attack,
              countryId: fromArea.countryId,
              fromAreaIndex: fromArea.areaIndex,
              toAreaIndex: toArea.areaIndex
            });
          }; //PhysicsSystem.instance.enable = false;


          PhysicsSystem.instance.autoSimulation = false;
        }

        enterGame() {
          this.frameSyncExecutor = new (_crd && FrameSyncExecutor === void 0 ? (_reportPossibleCrUseOfFrameSyncExecutor({
            error: Error()
          }), FrameSyncExecutor) : FrameSyncExecutor)(this.sceneMgr.gameClient, this, stateData => this.onSyncStateData(stateData), dt => this.executeOneFrame(dt), () => this.gameData.map);
        }

        exitGame() {
          var _this = this;

          return _asyncToGenerator(function* () {
            var _this$frameSyncExecut2;

            yield (_this$frameSyncExecut2 = _this.frameSyncExecutor) === null || _this$frameSyncExecut2 === void 0 ? void 0 : _this$frameSyncExecut2.dispose();
            _this.frameSyncExecutor = null;
          })();
        }

        clearMap() {
          this.gameData.allAreaInfo.forEach(n => {
            var _n$areaNode$parent, _n$flagNode$parent;

            (_n$areaNode$parent = n.areaNode.parent) === null || _n$areaNode$parent === void 0 ? void 0 : _n$areaNode$parent.removeChild(n.areaNode);
            (_n$flagNode$parent = n.flagNode.parent) === null || _n$flagNode$parent === void 0 ? void 0 : _n$flagNode$parent.removeChild(n.flagNode);
          });
          this.gameData.allAreaInfo.length = 0;
          this.gameData.allAttackingTroopInfo.forEach(n => {
            var _n$renderNode$parent, _n$troopNode$parent, _n$flagNode$parent2;

            (_n$renderNode$parent = n.renderNode.parent) === null || _n$renderNode$parent === void 0 ? void 0 : _n$renderNode$parent.removeChild(n.renderNode);
            (_n$troopNode$parent = n.troopNode.parent) === null || _n$troopNode$parent === void 0 ? void 0 : _n$troopNode$parent.removeChild(n.troopNode);
            (_n$flagNode$parent2 = n.flagNode.parent) === null || _n$flagNode$parent2 === void 0 ? void 0 : _n$flagNode$parent2.removeChild(n.flagNode);
          });
          this.gameData.allAttackingTroopInfo.length = 0;
        }

        createArea(area, country) {
          var areaInfo = (_crd && OTWAreaComponent === void 0 ? (_reportPossibleCrUseOfOTWAreaComponent({
            error: Error()
          }), OTWAreaComponent) : OTWAreaComponent).createNode(this.AreaPrefab, this.AreaFlagPrefab, this.getGameData, area, country, this.sceneMgr.MainCamera, this.node, this.GameObjFlagUI, this.GameObjContainer);
          this.gameData.allAreaInfo[areaInfo.area.areaIndex] = areaInfo;
          var collider = areaInfo.areaNode.getComponentInChildren(Collider);
          collider === null || collider === void 0 ? void 0 : collider.on('onTriggerEnter', event => {
            this.onTriggerEnter(event);
          });
          return areaInfo;
        }

        createTroop(troop, country) {
          var troopInfo = (_crd && OTWTroopComponent === void 0 ? (_reportPossibleCrUseOfOTWTroopComponent({
            error: Error()
          }), OTWTroopComponent) : OTWTroopComponent).createNode(this.TroopRenderPrefab, this.TroopColliderPrefab, this.TroopFlagPrefab, this.getGameData, troop, country, this.sceneMgr.MainCamera, this.node, this.GameObjFlagUI, this.GameObjContainer);
          this.gameData.allAttackingTroopInfo[troopInfo.troop.troopIndex] = troopInfo;
          var collider = troopInfo.troopNode.getComponentInChildren(Collider);
          collider === null || collider === void 0 ? void 0 : collider.on('onTriggerEnter', event => {
            this.onTriggerEnter(event);
          });
          return troopInfo;
        }

        onTriggerEnter(event) {
          console.log(event.type, event);
        }

        onSyncStateData(stateData) {
          var _this$gameData$map, _this$gameData$map2;

          //需要同步状态数据,当作重新初始化游戏数据
          this.clearMap();
          this.gameData.map = stateData;
          if (!this.gameData.map) return;
          this.gameData.myPlayer = this.gameData.map.allPlayer[this.sceneMgr.gameClient.connectionId];

          if (this.gameData.myPlayer) {
            this.gameData.myCountryId = this.gameData.myPlayer.countryId;
          }

          (_this$gameData$map = this.gameData.map) === null || _this$gameData$map === void 0 ? void 0 : _this$gameData$map.allArea.forEach(a => {
            var country = this.gameData.map.allCountry[a.countryId];
            this.createArea(a, country);
          });
          (_this$gameData$map2 = this.gameData.map) === null || _this$gameData$map2 === void 0 ? void 0 : _this$gameData$map2.allAttackingTroop.forEach(t => {
            var country = this.gameData.map.allCountry[t.countryId];
            this.createTroop(t, country);
          });
        }

        onAreaFlagUIUpdate(localUIPos, distanceScale, customEventData) {
          var areaIndex = parseInt(customEventData);
          var areaInfo = this.gameData.allAreaInfo[areaIndex];
          areaInfo.flagNode.setPosition(localUIPos);
        }

        onTroopFlagUIUpdate(localUIPos, distanceScale, customEventData) {
          var troopIndex = parseInt(customEventData);
          var troopInfo = this.gameData.allAttackingTroopInfo[troopIndex];
          troopInfo.flagNode.setPosition(localUIPos);
          console.log('onTroopFlagUIUpdate', localUIPos, customEventData);
        }

        execInput_NewPlayer(connId, inputFrame, dt) {
          var _this$sceneMgr$gameCl;

          if (!this.gameData.map) return; //新玩家进来,是取代某个电脑玩家

          var player = {
            connId: connId,
            userName: inputFrame.userName,
            countryId: inputFrame.countryId
          };
          this.gameData.map.allPlayer[player.connId] = player;
          var country = this.gameData.map.allCountry[player.countryId];
          country.playerConnId = player.connId; //更新flag

          for (var i = 0; i < this.gameData.map.allArea.length; i++) {
            var _this$gameData$allAre, _this$gameData$allAre2;

            var a = this.gameData.map.allArea[i];
            if (a.countryId != player.countryId) continue;
            (_this$gameData$allAre = this.gameData.allAreaInfo[a.areaIndex]) === null || _this$gameData$allAre === void 0 ? void 0 : (_this$gameData$allAre2 = _this$gameData$allAre.flagComp) === null || _this$gameData$allAre2 === void 0 ? void 0 : _this$gameData$allAre2.updateShow();
          }

          if (connId == ((_this$sceneMgr$gameCl = this.sceneMgr.gameClient) === null || _this$sceneMgr$gameCl === void 0 ? void 0 : _this$sceneMgr$gameCl.connectionId)) {
            this.gameData.myPlayer = this.gameData.map.allPlayer[this.sceneMgr.gameClient.connectionId];

            if (this.gameData.myPlayer) {
              this.gameData.myCountryId = this.gameData.myPlayer.countryId;
            }
          }
        }

        execInput_RemovePlayer(connId, inputFrame, dt) {
          if (!this.gameData.map) return; //玩家离开,将该玩家改成电脑玩家

          var player = this.gameData.map.allPlayer[connId];

          if (!player) {
            return;
          }

          delete this.gameData.map.allPlayer[connId];
          var country = this.gameData.map.allCountry[player.countryId];

          if (!country) {
            return;
          }

          country.playerConnId = null;
          delete this.gameData.map.allCountry[player.countryId]; //更新flag

          for (var i = 0; i < this.gameData.map.allArea.length; i++) {
            var _this$gameData$allAre3, _this$gameData$allAre4;

            var a = this.gameData.map.allArea[i];
            if (a.countryId != player.countryId) continue;
            (_this$gameData$allAre3 = this.gameData.allAreaInfo[a.areaIndex]) === null || _this$gameData$allAre3 === void 0 ? void 0 : (_this$gameData$allAre4 = _this$gameData$allAre3.flagComp) === null || _this$gameData$allAre4 === void 0 ? void 0 : _this$gameData$allAre4.updateShow();
          }
        }

        execInput_Attack(connId, inputFrame, dt) {
          if (!this.gameData.map) return;
          var country = inputFrame.countryId ? this.gameData.map.allCountry[inputFrame.countryId] : null;

          if (!country) {
            //没有国家,则不能发动攻击
            return;
          }

          var fromArea = this.gameData.map.allArea[inputFrame.fromAreaIndex];
          if (fromArea.troopsCurr <= 0) return; //兵力为0则不能发动攻击

          var troop = {
            troopIndex: this.gameData.map.allAttackingTroop.length,
            countryId: country.countryId,
            fromAreaIndex: inputFrame.fromAreaIndex,
            toAreaIndex: inputFrame.toAreaIndex,
            troopsCount: fromArea.troopsCurr,
            x: fromArea.x,
            z: fromArea.z
          };
          this.gameData.map.allAttackingTroop[troop.troopIndex] = troop;
          this.createTroop(troop, country);
          fromArea.troopsCurr = 0;
          fromArea.troopsCurrCalculate = 0;
          var fromAreaInfo = this.gameData.allAreaInfo[fromArea.areaIndex];
          fromAreaInfo.flagComp.updateShow();
        }

        executeOneFrame(dt) {
          //运算增兵
          for (var i = 0; i < this.gameData.allAreaInfo.length; i++) {
            this.gameData.allAreaInfo[i].areaComp.updateData(dt);
          } //物理分离
          //PhysicsSystem.instance.step(dt, dt);
          //PhysicsSystem.instance.emitEvents();

        }

        update(dt) {
          //运算移动以及产生的效果
          for (var i = 0; i < this.gameData.allAttackingTroopInfo.length; i++) {
            this.gameData.allAttackingTroopInfo[i].troopComp.updateData(dt);
          }
        }
        /*
            playerUpdate(player: PlayerData, dt: number) {
                if (player.moveDirX != 0 || player.moveDirZ != 0) {
                    //有移动,转向直接生效,小方块,懒得转忽略
                    var distance = player.speed * dt;//本帧移动的距离
        
                    var oldX = player.x;
                    var oldZ = player.z;
        
                    var cosA = Math.cos(player.moveAcuteRad);
                    var sinA = Math.sin(player.moveAcuteRad);
        
                    var stepReC = distance;
        
                    var stepReX = player.moveDirZ == 0 ?
                        player.moveDirX * distance : cosA * stepReC * player.moveDirX;//如果Z方向没动,直接用X方向的距离
                    var stepReZ = player.moveDirX == 0 ?
                        player.moveDirZ * distance : sinA * stepReC * player.moveDirZ;//如果X方向没动,直接用Z方向的距离
        
                    player.x = oldX + stepReX;
                    player.z = oldZ + stepReZ;
                }
            }*/


      }, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "GameObjContainer", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "GameObjFlagUI", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "AreaPrefab", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "AreaFlagPrefab", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "TroopRenderPrefab", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "TroopColliderPrefab", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "TroopFlagPrefab", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=OTWGameManager.js.map