System.register(["__unresolved_0"], function (_export, _context) {
  "use strict";

  var _loader, _cjsExports, __cjsMetaURL;

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _loader = _unresolved_.default;
    }],
    execute: function () {
      _loader.define(_context.meta.url, function (exports, _require, module, __filename, __dirname) {
        var require = _loader.createRequireWithReqMap({}, _require);

        (function () {
          ///<reference path="index.d.ts"/>
          var _a;

          var extendFuncs = {
            remove: function remove(filter) {
              if (typeof filter == 'function') {
                for (var i = this.length - 1; i > -1; --i) {
                  filter(this[i], i, this) && this.splice(i, 1);
                }
              } else {
                for (var i = this.length - 1; i > -1; --i) {
                  this[i] === filter && this.splice(i, 1);
                }
              }

              return this;
            },
            removeOne: function removeOne(filter) {
              if (typeof filter == 'function') {
                for (var i = 0; i < this.length; ++i) {
                  if (filter(this[i], i, this)) {
                    this.splice(i, 1);
                    return this;
                  }
                }
              } else {
                for (var i = 0; i < this.length; ++i) {
                  if (this[i] === filter) {
                    this.splice(i, 1);
                    return this;
                  }
                }
              }

              return this;
            },
            first: function first() {
              return this.length ? this[0] : null;
            },
            last: function last() {
              return this.length ? this[this.length - 1] : null;
            },
            max: function max(mapper) {
              if (!this.length) {
                return null;
              }

              if (typeof mapper == 'function') {
                var max = mapper(this[0], 0, this);

                for (var i = 1; i < this.length; ++i) {
                  var temp = mapper(this[i], i, this);
                  max = temp > max ? temp : max;
                }

                return max;
              } else {
                return this.reduce(function (prev, cur) {
                  return prev > cur ? prev : cur;
                });
              }
            },
            min: function min(mapper) {
              if (!this.length) {
                return null;
              }

              function _min(a, b) {
                return a < b ? a : b;
              }

              if (typeof mapper == 'function') {
                var min = mapper(this[0], 0, this);

                for (var i = 1; i < this.length; ++i) {
                  var temp = mapper(this[i], i, this);
                  min = temp < min ? temp : min;
                }

                return min;
              } else {
                return this.reduce(function (prev, cur) {
                  return _min(prev, cur);
                });
              }
            },
            distinct: function distinct() {
              return this.filter(function (v, i, arr) {
                return arr.indexOf(v) === i;
              });
            },
            filterIndex: function filterIndex(filter) {
              var output = [];

              for (var i = 0; i < this.length; ++i) {
                if (filter(this[i], i, this)) {
                  output.push(i);
                }
              }

              return output;
            },
            count: function count(filter) {
              var result = 0;

              for (var i = 0; i < this.length; ++i) {
                if (filter(this[i], i, this)) {
                  ++result;
                }
              }

              return result;
            },
            sum: function sum(mapper) {
              var result = 0;

              for (var i = 0; i < this.length; ++i) {
                result += mapper ? mapper(this[i], i, this) : this[i];
              }

              return result;
            },
            average: function average(mapper) {
              return this.sum(mapper) / this.length;
            },
            orderBy: function orderBy() {
              var mappers = [];

              for (var _i = 0; _i < arguments.length; _i++) {
                mappers[_i] = arguments[_i];
              }

              return this.slice().sort(function (a, b) {
                for (var i = 0; i < mappers.length; ++i) {
                  var va = mappers[i](a);
                  var vb = mappers[i](b);

                  if (va > vb) {
                    return 1;
                  } else if (va < vb) {
                    return -1;
                  }
                }

                return 0;
              });
            },
            orderByDesc: function orderByDesc() {
              var mappers = [];

              for (var _i = 0; _i < arguments.length; _i++) {
                mappers[_i] = arguments[_i];
              }

              return this.slice().sort(function (a, b) {
                for (var i = 0; i < mappers.length; ++i) {
                  var va = mappers[i](a);
                  var vb = mappers[i](b);

                  if (va > vb) {
                    return -1;
                  } else if (va < vb) {
                    return 1;
                  }
                }

                return 0;
              });
            },
            binarySearch: function binarySearch(value, keyMapper) {
              var low = 0,
                  high = this.length - 1;

              while (low <= high) {
                var mid = (high + low) / 2 | 0;
                var midValue = keyMapper ? keyMapper(this[mid]) : this[mid];

                if (value === midValue) {
                  return mid;
                } else if (value > midValue) {
                  low = mid + 1;
                } else if (value < midValue) {
                  high = mid - 1;
                }
              }

              return -1;
            },
            binaryInsert: function binaryInsert(item, keyMapper, unique) {
              if (typeof keyMapper == 'boolean') {
                unique = keyMapper;
                keyMapper = undefined;
              }

              var low = 0,
                  high = this.length - 1;
              var mid = NaN;
              var itemValue = keyMapper ? keyMapper(item) : item;

              while (low <= high) {
                mid = (high + low) / 2 | 0;
                var midValue = keyMapper ? keyMapper(this[mid]) : this[mid];

                if (itemValue === midValue) {
                  if (unique) {
                    return mid;
                  } else {
                    break;
                  }
                } else if (itemValue > midValue) {
                  low = mid + 1;
                } else if (itemValue < midValue) {
                  high = mid - 1;
                }
              }

              var index = low > mid ? mid + 1 : mid;
              this.splice(index, 0, item);
              return index;
            },
            binaryDistinct: function binaryDistinct(keyMapper) {
              return this.filter(function (v, i, arr) {
                return arr.binarySearch(v, keyMapper) === i;
              });
            },
            findLast: function findLast(predicate) {
              for (var i = this.length - 1; i > -1; --i) {
                if (predicate(this[i], i, this)) {
                  return this[i];
                }
              }

              return undefined;
            },
            findLastIndex: function findLastIndex(predicate) {
              for (var i = this.length - 1; i > -1; --i) {
                if (predicate(this[i], i, this)) {
                  return i;
                }
              }

              return -1;
            },
            groupBy: function groupBy(grouper) {
              var group = this.reduce(function (prev, next) {
                var groupKey = grouper(next);

                if (!prev[groupKey]) {
                  prev[groupKey] = [];
                }

                prev[groupKey].push(next);
                return prev;
              }, {});
              return Object.keys(group).map(function (key) {
                var arr = group[key];
                arr.key = key;
                return arr;
              });
            },
            __k8w_extended: {
              value: true
            }
          };

          if (!Array.prototype.__k8w_extended) {
            for (var key in extendFuncs) {
              Object.defineProperties(Array.prototype, (_a = {}, _a[key] = {
                value: extendFuncs[key],
                writable: true
              }, _a));
            }
          }
        })();

        _export("default", _cjsExports = module.exports);
      });

      _export("__cjsMetaURL", __cjsMetaURL = _context.meta.url);
    }
  };
});
//# sourceMappingURL=index.js.map