System.register(["__unresolved_0"], function (_export, _context) {
  "use strict";

  var _loader, _cjsExports, __cjsMetaURL;

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _loader = _unresolved_.default;
    }],
    execute: function () {
      _loader.define(_context.meta.url, function (exports, _require, module, __filename, __dirname) {
        var require = _loader.createRequireWithReqMap({}, _require);

        (function () {
          ///<reference path="index.d.ts"/>

          /**
           * 将sources合并到target，该合并全部是深拷贝
           * @param target
           * @param sources
           * @returns {Object}
           */
          Object.merge = function (target) {
            var sources = [];

            for (var _i = 1; _i < arguments.length; _i++) {
              sources[_i - 1] = arguments[_i];
            }

            for (var i = 0; i < sources.length; ++i) {
              var source = sources[i];

              if (typeof source != 'object' || source == null) {
                continue;
              }

              for (var skey in source) {
                //只处理自身的key 这里可能来自于外部prototype的扩展
                if (!source.hasOwnProperty(skey)) {
                  continue;
                }

                if (source[skey] instanceof Date) {
                  //Date类型 要克隆一份 保证深拷贝
                  target[skey] = new Date(source[skey]);
                  continue;
                } else if (typeof target[skey] == 'object' && target[skey] != null && typeof source[skey] == 'object' && source[skey] != null) {
                  // 两个都是Object 递归merge之
                  Object.merge(target[skey], source[skey]);
                } else {
                  if (Array.isArray(source[skey])) {
                    // 数组merge后还是数组
                    target[skey] = Object.merge([], source[skey]);
                  } else if (typeof source[skey] == 'object' && source[skey] !== null) {
                    // Object要克隆一份以确保深拷贝
                    target[skey] = Object.merge({}, source[skey]);
                  } else {
                    // 基本类型 直接赋值即可
                    target[skey] = source[skey];
                  }
                }
              }
            }

            return target;
          };

          if (!Object.values) {
            Object.values = function (obj) {
              var output = [];

              for (var k in obj) {
                obj.hasOwnProperty(k) && output.push(obj[k]);
              }

              return output;
            };
          }

          if (!Object.entries) {
            Object.entries = function (obj) {
              var output = [];

              for (var key in obj) {
                if (!obj.hasOwnProperty(key)) {
                  continue;
                }

                output.push([key, obj[key]]);
              }

              return output;
            };
          }

          Object.forEach = function (obj, handler) {
            for (var key in obj) {
              if (!obj.hasOwnProperty(key)) {
                return;
              }

              handler(obj[key], key, obj);
            }
          };
        })();

        _export("default", _cjsExports = module.exports);
      });

      _export("__cjsMetaURL", __cjsMetaURL = _context.meta.url);
    }
  };
});
//# sourceMappingURL=index.js.map