System.register(["tslib"], function (_export, _context) {
  "use strict";

  var __assign, TsrpcErrorType, TransportDataProto, TsrpcError;

  _export("TsrpcErrorType", void 0);

  return {
    setters: [function (_tslib) {
      __assign = _tslib.__assign;
    }],
    execute: function () {
      (function (TsrpcErrorType) {
        /** Network error, like connection broken, network timeout, etc. */
        TsrpcErrorType["NetworkError"] = "NetworkError";
        /**
         * Server exception, for example "request format error", "database exception", etc.
         *
         * @remarks
         * This error message may be not suitable to show to user,
         * but the error info is useful for engineer to find some bug.
         * So you can show a user-friendly message to user (like "System error, please contact XXX"),
         * and report some debug info at the same time.
         */

        TsrpcErrorType["ServerError"] = "ServerError";
        /** Client exception, for example parse server output error.
         * (May because of the proto file is not the same between server and client)
         */

        TsrpcErrorType["ClientError"] = "ClientError";
        /**
         * The business error returned by `call.error`.
         * It is always business-relatived, for example `call.error('Password is incorrect')`, `call.error('Not enough credit')`, etc.
         */

        TsrpcErrorType["ApiError"] = "ApiError";
      })(TsrpcErrorType || _export("TsrpcErrorType", TsrpcErrorType = {}));

      _export("TransportDataProto", TransportDataProto = {
        "ServerInputData": {
          "type": "Interface",
          "properties": [{
            "id": 0,
            "name": "serviceId",
            "type": {
              "type": "Number",
              "scalarType": "uint"
            }
          }, {
            "id": 1,
            "name": "buffer",
            "type": {
              "type": "Buffer",
              "arrayType": "Uint8Array"
            }
          }, {
            "id": 2,
            "name": "sn",
            "type": {
              "type": "Number",
              "scalarType": "uint"
            },
            "optional": true
          }]
        },
        "ServerOutputData": {
          "type": "Interface",
          "properties": [{
            "id": 0,
            "name": "buffer",
            "type": {
              "type": "Buffer",
              "arrayType": "Uint8Array"
            },
            "optional": true
          }, {
            "id": 1,
            "name": "error",
            "type": {
              "type": "Reference",
              "target": "TsrpcErrorData"
            },
            "optional": true
          }, {
            "id": 2,
            "name": "serviceId",
            "type": {
              "type": "Number",
              "scalarType": "uint"
            },
            "optional": true
          }, {
            "id": 3,
            "name": "sn",
            "type": {
              "type": "Number",
              "scalarType": "uint"
            },
            "optional": true
          }]
        },
        "TsrpcErrorData": {
          "type": "Interface",
          "properties": [{
            "id": 0,
            "name": "message",
            "type": {
              "type": "String"
            }
          }, {
            "id": 1,
            "name": "type",
            "type": {
              "type": "Reference",
              "target": "TsrpcErrorType"
            }
          }, {
            "id": 2,
            "name": "code",
            "type": {
              "type": "Union",
              "members": [{
                "id": 0,
                "type": {
                  "type": "String"
                }
              }, {
                "id": 1,
                "type": {
                  "type": "Number",
                  "scalarType": "int"
                }
              }]
            },
            "optional": true
          }],
          "indexSignature": {
            "keyType": "String",
            "type": {
              "type": "Any"
            }
          }
        },
        "TsrpcErrorType": {
          "type": "Enum",
          "members": [{
            "id": 0,
            "value": "NetworkError"
          }, {
            "id": 1,
            "value": "ServerError"
          }, {
            "id": 2,
            "value": "ClientError"
          }, {
            "id": 3,
            "value": "ApiError"
          }]
        }
      });
      /**
       * A unified Error that returned by TSRPC server or client
       *
       * @remarks
       * It has many uses, for example:
       *
       * 1. You can handle business errors and network errors uniformly.
       * 2. In API handle process, `throw new TsrpcError('xxx')` would return the same error to client directly (like `call.error()`),
       * while `throw new Error('XXX')` would return a unified "Server Internal Error".
       */


      _export("TsrpcError", TsrpcError =
      /** @class */
      function () {
        function TsrpcError(dataOrMessage, data) {
          var _a;

          if (typeof dataOrMessage === 'string') {
            this.message = dataOrMessage;
            this.type = (_a = data === null || data === void 0 ? void 0 : data.type) !== null && _a !== void 0 ? _a : TsrpcErrorType.ApiError;

            __assign(this, data);
          } else {
            __assign(this, dataOrMessage);
          }
        }

        TsrpcError.prototype.toString = function () {
          return "[TSRPC ".concat(this.type, "]: ").concat(this.message);
        };

        TsrpcError.Type = TsrpcErrorType;
        return TsrpcError;
      }());
    }
  };
});
//# sourceMappingURL=index.js.map