
import { _decorator, Component, Node, tween} from 'cc';
const { ccclass } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    location = null;
    
    attrArray = [
        {
            name: "card0",
            zIndex: 5,
            scale: 1,
        },
        {
            name: "card1",
            zIndex: 4,
            scale: 0.9,
        },
        {
            name: "card2",
            zIndex: 3,
            scale: 0.8,
        },
        {
            name: "card3",
            zIndex: 2,
            scale: 0.7,
        },
        {
            name: "card4",
            zIndex: 1,
            scale: 0.6,
        },
        {
            name: "card5",
            zIndex: 2,
            scale: 0.7,
        },
        {
            name: "card6",
            zIndex: 3,
            scale: 0.8,
        },
        {
            name: "card7",
            zIndex: 4,
            scale: 0.9,
        } 
    ];

    
    start () {
        for (let i = 0; i < this.attrArray.length; i++) {
            let attr = this.attrArray[i];
            let thisNode = this.node.getChildByName(attr.name);
            thisNode.setSiblingIndex(attr.zIndex);
            //zIndex总是不受控制，不太懂怎么回事，那就把zIndex放到参数z里面吧。。。。。
            thisNode.setScale(attr.scale, attr.scale, attr.zIndex);
            console.info(thisNode.getSiblingIndex());
        }
        console.info("--------漂亮的分割线--------");
        this.node.parent.on(Node.EventType.TOUCH_START, this.touchStart, this);
        this.node.parent.on(Node.EventType.TOUCH_END, this.touchEnd, this);
    }

    touchStart(event){
        this.location =  event.getLocation();
    }
        
    touchEnd (event) {
        let deltaX = event.getLocation().x - this.location.x;
        if(deltaX == 0) return;
        deltaX > 0 ? this.revolveRight() : this.revolveLeft();
        //为什么再次获取zIndex，就被重置了呢？
        for(let i = 0; i < this.attrArray.length; i++){
            let thisNode = this.node.getChildByName(this.attrArray[i].name);
            console.info(thisNode.getSiblingIndex());
        }
        console.info("--------touchEnd--------");
    }

    revolveRight() {
        let firstNode = this.node.getChildByName(this.attrArray[0].name);
        for(let i = 0; i < this.attrArray.length; i++){
            let thisNode = this.node.getChildByName(this.attrArray[i].name);
            let nextNode = (i == this.attrArray.length - 1) ? firstNode : this.node.getChildByName(this.attrArray[i + 1].name);
            let tween_position = tween().to(1, { position: thisNode.getPosition() });
            let tween_scale = tween().to(1, { scale: thisNode.getScale() });
            tween(nextNode).parallel(tween_position,tween_scale).start();
            nextNode.setSiblingIndex(thisNode.getScale().z);          
        }
    }
        
    revolveLeft(){
        let lastNode = this.node.getChildByName(this.attrArray[this.attrArray.length - 1].name);
        for(let i = 0; i < this.attrArray.length; i++){
            let thisNode = this.node.getChildByName(this.attrArray[i].name);
            let nextNode = (i == 0) ? lastNode : this.node.getChildByName(this.attrArray[i - 1].name);
            let tween_position = tween().to(1, { position: thisNode.getPosition() });
            let tween_scale = tween().to(1, { scale: thisNode.getScale() });
            tween(nextNode).parallel(tween_position,tween_scale).start();
            nextNode.setSiblingIndex(thisNode.getScale().z);
        }
    }

}
