
import { _decorator, Component, Node, resources, Prefab, instantiate, find, v3 } from 'cc';
import { EDITOR } from 'cc/env';
const { ccclass, property, executeInEditMode } = _decorator;


@ccclass('Editor')
@executeInEditMode(true)
export class Editor extends Component {

    @property(Prefab)
    block: Prefab = null;

    //问题1：编辑器模式下 resources.load 加载失败，正式模式下加载成功，cocos2.4.7版本编辑器模式下也可以正常加载
    //问题2：连续创建节点时报错,(经过测试再start函数中执行就不会报错)

    onLoad() {
        if (EDITOR) {
            console.log("编辑器模式");
            this.loadPrefab();
        } else {
            console.log("正式模式");
            this.loadPrefab();
        }

        let blockBox = find("blockBox", this.node);
        blockBox.removeAllChildren();

        for (let i = 0;i < 10;i++) {
            let node = instantiate(this.block);
            node.setParent(blockBox);
            node.position = v3(i * 80, 0, 0);
        }
    }

    start() {

    }

    loadPrefab() {
        resources.load("block", Prefab, (err, res) => {
            if (!err) {
                console.log("加载成功", res);
                this.block = res;
            } else {
                console.error("加载失败", err);
            }
        })
    }

}
