import { CCFloat, CCInteger, instantiate, math, Prefab, ScrollView, UITransform, _decorator,Node, v3, CCBoolean, Button, Size } from "cc";

const { ccclass, property } = _decorator;

@ccclass('List')
export class List extends ScrollView{
    private _numItems:number = 0;
    private _colNum:number = 1
    private _rowNum:number = 1
    private _padingX:number = 1
    private _padingY:number = 1
    private _itemWidth:number = 0;
    private _itemHeight:number = 0;
    private _virtual:boolean = false;
    private _startIndex:number = NaN;//虚拟列表显示的第一个条目下标
    private _itemRender:Function;
    private _itemClick:Function;
    
    @property({displayName:"defaultItem",type:Prefab,tooltip:"条目预设"})
    public defaultItem:Prefab;

    @property({displayName:"numItems",type:CCInteger,tooltip:"条目数量"})
    public get numItems(){return this._numItems;}
    public set numItems(val:number){
        val = Math.max(0,Math.floor(val));
        this._numItems = val;
        this.updateItem();
    }
    /**
     * 列数
    */
     @property({displayName:"colNum",type:CCInteger,tooltip:"列数"})
    public get colNum(){return this._colNum;}
    public set colNum(val){
        val = Math.max(1,Math.floor(val));
        this._colNum = val;
        this.updateItem();
    }
    /**
     * 行数
    */
    @property({displayName:"rowNum",type:CCInteger,tooltip:"行数"})
    public get rowNum(){return this._rowNum;}
    public set rowNum(val){
        val = Math.max(1,Math.floor(val));
        this._rowNum = val;
        this.updateItem();
    }
    /**
     * 列间距
    */
    @property({displayName:"padingX",type:CCFloat,tooltip:"列间距"})
    public get padingX(){return this._padingX;}
    public set padingX(val){
        this._padingX = val;
        this.updateItem();
    }
    /**
     * 行间距
     */
    @property({displayName:"padingY",type:CCFloat,tooltip:"行间距"})
    public get padingY(){return this._padingY;}
    public set padingY(val){
        this._padingY = val;
        this.updateItem();
    }
    /**
     * 条目宽度
     */
    @property({displayName:"itemWidth",type:CCFloat,tooltip:"条目宽度"})
    public get itemWidth(){return this._itemWidth;}
    public set itemWidth(val){
        this._itemWidth = val;
        this.updateItem();
    }
    /**
     * 条目高度
     */
    @property({displayName:"itemHeight",type:CCFloat,tooltip:"条目高度"})
    public get itemHeight(){return this._itemHeight;}
    public set itemHeight(val){
        this._itemHeight = val;
        this.updateItem();
    }
    /**
     * 是否虚拟列表
     */
    @property({displayName:"virtual",type:CCBoolean,tooltip:"是否虚拟列表"})
    public get virtual(){return this._virtual;}
    public set virtual(val){this._virtual = val;}

    public set itemRender(val){this._itemRender = val;}
    public set itemClick(val){this._itemClick = val;}

    private _itemPool:Node[] = [];
    onLoad(){
        this.node.on(ScrollView.EventType.SCROLLING,this.onScrolling,this);
        this.updateItem();
    }
    onDestroy(){
        this.node.off(ScrollView.EventType.SCROLLING,this.onScrolling,this);
        this.clearPool();
    }
    onScrolling(){
        if(this.virtual){
            this.updateItemPostion();
        }
    }
    caculateRealItems(){
        if(!this.virtual)return this.numItems;
        let itemSize = this.$getItemSize();
        let viewSize = this.node.getComponent(UITransform).contentSize;
        let realNum = 0;
        if(this.horizontal){
            //计算出可显示列数
            let showCol = Math.ceil(viewSize.width / (itemSize.width + this.padingX)) + 1;//多预留一列
            realNum = showCol * this.rowNum;
        }else{
            let showRow = Math.ceil(viewSize.height / (itemSize.height + this.padingY)) + 1;
            realNum = showRow * this.colNum;
        }
        return Math.min(realNum,this.numItems)
    }
    caculateFirstItemIndex(){
        if(!this.virtual)return 0;
        let itemSize = this.$getItemSize();
        let viewTransform = this.node.getComponent(UITransform);
        let contentTransform = this.content.getComponent(UITransform);
        //view左上角坐标
        let viewLeft = -viewTransform.contentSize.width * viewTransform.anchorX;
        let viewTop = viewTransform.contentSize.height * (1 - viewTransform.anchorY);
        let local = v3(viewLeft,viewTop);
        //convert view to content
        viewTransform.convertToWorldSpaceAR(local,local);
        contentTransform.convertToNodeSpaceAR(local,local);
        let index = 0;
        if(this.horizontal){
            let contentLeft = -contentTransform.contentSize.width * contentTransform.anchorX;
            let outX = local.x - contentLeft;
            index = Math.floor(outX / itemSize.width) * this.rowNum;//超出的个数正好是显示中第一个的下标 
        }else{
            let contentTop = contentTransform.contentSize.height * (1 - contentTransform.anchorY);
            let outY = contentTop - local.y;
            index = Math.floor(outY / itemSize.height) * this.colNum;
        }
        return index;
    }
    /**
     * 创建条目对象
    */
    public createItem(){
        let item;
        if(this._itemPool.length){
            item = this._itemPool.shift();
        }
        item = instantiate(this.defaultItem);
        item.active = true;
        return item;
    }
    public recoverAllItem(){
        if(!this.content)return;
        let len = this.content.children.length;
        for (let index = 0; index < len; index++) {
            const oldItem = this.content.children[index];
            if(this._itemClick){
                oldItem.targetOff(this)
            }
            this.recoverItem(oldItem);
        }
        this.content.removeAllChildren();
    }
    /**
     * 回收条目对象
    */
    public recoverItem(item:Node){
        this._itemPool.push(item);
    }
    public clearPool(){
        for (let index = 0; index < this._itemPool.length; index++) {
            let item = this._itemPool[index];
            item.destroy()
        }
        this._itemPool.length = 0;
    }
    private $getItemSize(){
        let width,height;
        let item = this.createItem();
        let size = item.getComponent(UITransform).contentSize;
        width = this.itemWidth != 0?this.itemWidth:size.width;
        height = this.itemHeight != 0?this.itemHeight:size.height;
        this.recoverItem(item);
        return math.size(width,height);
    }
    updateItem() {
        if(!this.content)return;
        this._startIndex = NaN;
        this.recoverAllItem();
        let realNum = this.numItems;
        if(this._virtual){
            realNum = this.caculateRealItems();
        }
        for (let index = 0; index < realNum; index++) {
            let item = this.createItem();
            if(this._itemClick){
                item.on("click",(e)=>{
                    this._itemClick(item["realIndex"],item,e)
                },this)
            }
            this.content.addChild(item);
        }
        this.updateContentSize();
        this.updateItemPostion();
    }
    updateContentSize(){
        if(this._numItems == 0 || !this.content)return;
        let itemSize = this.$getItemSize();
        //计算content大小
        if(this.horizontal){
            //固定行数
            let totalCol = Math.ceil(this.numItems / this.rowNum);
            let contentWidth = itemSize.width * totalCol + this.padingX * (totalCol - 1);
            let contentHeight = itemSize.height * this.rowNum + this.padingY * (this.rowNum - 1);
            this.content.getComponent(UITransform).setContentSize(contentWidth,contentHeight);
            this.vertical = false;
        }else{
            //固定列数
            let totalRow = Math.ceil(this.numItems / this.colNum);
            let contentWidth = itemSize.width * this.colNum + this.padingX * (this.colNum - 1);
            let contentHeight = itemSize.height * totalRow + this.padingY * (totalRow - 1);
            this.content.getComponent(UITransform).setContentSize(contentWidth,contentHeight);
        }
    }
    updateItemPostion(){
        let startIndex = 0;
        let realNum = this.numItems;
        let col = 0,row = 0;
        if(this._virtual){
            startIndex = this.caculateFirstItemIndex();
            if(startIndex < 0)return;
            realNum = this.caculateRealItems();
            if(startIndex + realNum > this.numItems)return;
            if(this._startIndex == startIndex)return;//条目显示中,避免重复计算
            this._startIndex = startIndex;
            if(this.horizontal){
                col = startIndex / this.rowNum;
            }else{
                row = startIndex / this.colNum;
            }
        }
        let contentTransform = this.content.getComponent(UITransform);
        let startX = -contentTransform.contentSize.width * contentTransform.anchorX;
        let startY = contentTransform.contentSize.height * (1 - contentTransform.anchorY);
        let itemSize = this.$getItemSize();
        for (let i = 0; i < realNum; i++) {
            let item = this.content.children[i];
            let itemTransfrom = item.getComponent(UITransform);
            itemTransfrom.setContentSize(itemSize);
            let itemX = startX + col*(itemTransfrom.contentSize.width + this.padingX) + itemTransfrom.contentSize.width * itemTransfrom.anchorX;
            let itemY = startY - row*(itemTransfrom.contentSize.height + this.padingY) - itemTransfrom.contentSize.height * itemTransfrom.anchorY;
            item.setPosition(itemX,itemY);
            item["realIndex"] = i + startIndex;//记录条目真实下标
            if(this._itemRender)this._itemRender(i + startIndex,item);
            if(this.horizontal){
                row++;
                if(row >= this.rowNum){
                    row = 0;
                    col++;
                }
            }else{
                col++;
                if(col >= this.colNum){
                    col = 0;
                    row++;
                }
            }
        }
    }
}
