import { _decorator, AssetManager, assetManager, Component, Node, resources, Sprite, SpriteFrame } from 'cc';
import { EDITOR } from 'cc/env';
import { LoadRes } from './Util';
const { ccclass, property, executeInEditMode, menu } = _decorator;
function ExtractResourcesPath(dbUrl: string): string {
    const prefix = 'db://assets/resources/';
    if (!dbUrl.startsWith(prefix))
        return '';
    return dbUrl.slice(prefix.length).replace(/@.+$/, '').replace(/\.[^/.]+$/, '');
}
@ccclass('SpriteLoader')
@executeInEditMode
@menu("异步精灵/SpriteLoader")
export class SpriteLoader extends Sprite {
    @property({ type: SpriteFrame, serializable: false, visible: false })
    protected _spriteFrame: SpriteFrame | null = null;
    @property({ type: String, serializable: true, visible: false })
    public mSpriteUrl: string;
    @property({ type: String, serializable: true, visible: false })
    public mSpriteUUID: string;

    @property({ type: SpriteFrame })
    get spriteFrame(): SpriteFrame {
        const descriptor = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(Sprite.prototype), 'spriteFrame') || Object.getOwnPropertyDescriptor(Sprite.prototype, 'spriteFrame');
        return descriptor?.get?.call(this);
    }
    set spriteFrame(value: SpriteFrame) {
        if (!EDITOR) {
            console.warn("非编辑器模式，不能进行此值的设置");
            return;
        }
        this.SetSpriteData(value);
    }

    public get __spriteFrame(): SpriteFrame {
        return this.spriteFrame;
    }
    public set __spriteFrame(spriteFrame: SpriteFrame) {
        const descriptor = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(Sprite.prototype), 'spriteFrame') || Object.getOwnPropertyDescriptor(Sprite.prototype, 'spriteFrame');
        descriptor?.set?.call(this, spriteFrame);//调用父类构造
    }

    public SetSpriteData(spriteFrame: SpriteFrame) {
        if (EDITOR) {
            this.mSpriteUUID = spriteFrame ? spriteFrame._uuid : "";//获取到位移UUID
            this.url = "";
            Editor.Message.request('asset-db', 'query-url', spriteFrame._uuid).then((data1) => {
                let resourcesPath: string = ExtractResourcesPath(data1);
                this.url = resourcesPath;
                this.UpdateSpriteFrame();//立即更新图片资源
            });
        } else
            this.UpdateSpriteFrame();//立即更新图片资源
    }

    @property({ type: String, readonly: true })
    public get url(): string { return this.mSpriteUrl; }
    public set url(path: string) {
        this.mSpriteUrl = path;
        this.UpdateSpriteFrame();
    }

    private UpdateSpriteFrame() {
        if (EDITOR) {
            assetManager.loadAny({ uuid: this.mSpriteUUID, }, (err, data) => {
                if (err)
                    return console.warn(err);
                this.__spriteFrame = data;
            });
        } else{
            //LoadRes<SpriteLoader>(this, "__spriteFrame", this.mSpriteUrl, SpriteFrame);
            resources.load( this.mSpriteUrl + "/spriteFrame" , SpriteFrame , ( err , data )=>{
                if (err)
                    return console.warn(err);
                this.__spriteFrame = data;
            })
        }
    }

    protected onLoad(): void {
        super.onLoad();
        this.UpdateSpriteFrame();
    }
}