/**
 * 音频管理
 * @author 神兽白泽
 * @description 交流群：415468592
 */
import * as cc from 'cc';
// import { AudioConfig } from "./AudioConfig";
enum AudioConfig {
    ///////////////// BGM 同一时间，只能播放一个  ///////////////////
    /** 大厅 BGM */
    HallBgm = "HallBgm",
    // /** 局内 BGM */
    // GameBgm = "GameBgm",
    /////////////////// 音效 ///////////////////
    /** 胜利 */
    Victory = "Victory",
    /** 失败 */
    Fail = "Fail",
    /** 点击 */
    Click = "Click",
    /** 获得硬币 */
    GoldRewardItem = "GoldRewardItem",
}
export default class AudioMgr {
    // constructor() {}
    /** 音频列表 - 池子 */
    private _audio_list: Map<string, cc.AudioSource> = new Map();
    /** BGM */
    private _audio_bgm: cc.AudioSource | null = null;
    /** 音效 音量 */
    private sound_volume: number = 1;
    /** 音乐 音量 */
    private bgm_volume: number = 1;
    /** 音频根路径 */
    private path: string = "audio/";
    /**
    * 播放音频
    * @param audio_name 音频文件名
    * @param loop 是否循环
    * @param volume 音量
    * @param bgm 是bgm
    */
    public async play(audio_name: keyof typeof AudioConfig, loop: boolean = false, volume?: number, bgm?: boolean) {
        let comp_audio = this._audio_list.get(audio_name);
        if (!comp_audio) {
            let node_audio = new cc.Node();
            comp_audio = node_audio.addComponent(cc.AudioSource);
            this._audio_list.set(audio_name, comp_audio);
        }
        if (!comp_audio.clip) {
            let assert = await fw.loader.loadAssetByType(this.path + audio_name, cc.AudioClip)
            comp_audio.clip = assert;
        }
        if (bgm && this._audio_bgm) {
            if (this._audio_bgm == comp_audio) {
                return;
            } else {
                this._audio_bgm.stop();
            }
        }
        comp_audio.volume = volume ? volume : bgm ? this.bgm_volume : this.sound_volume;
        comp_audio.loop = loop;
        comp_audio.play();
        if (bgm) this._audio_bgm = comp_audio;
    }
    /**
    * 停止播放
    * @param audio_name 音频文件名
    * @returns
    */
    public stop(audio_name: keyof typeof AudioConfig) {
        let comp_audio = this._audio_list.get(audio_name);
        if (!comp_audio) {
            console.log("音频不存在");
            return;
        }
        comp_audio.stop();
    }
    /**
    * 暂停播放
    * @param audio_name 音频文件名
    * @returns
    */
    public pause(audio_name: keyof typeof AudioConfig) {
        let comp_audio = this._audio_list.get(audio_name);
        if (!comp_audio) {
            console.log("音频不存在");
            return;
        }
        comp_audio.pause();
    }
    /**
     * 暂停所有
     */
    public pauseAll() {
        this._audio_list.forEach((value, key) => {
            this.pause(key as any);
        });
    }
    /**
    * 暂停 BGM
    */
    public pauseBGM() {
        if (!this._audio_bgm) {
            console.log("音频不存在");
            return;
        }
        if (this._audio_bgm.playing) {
            console.log("暂停播放bgm");
            this._audio_bgm.pause();
        } else {
            console.log("bgm 暂停中");
        }
    }
    /**
    * 继续播放 BGM
    */
    public resumeBGM() {
        if (!this._audio_bgm) {
            console.log("音频不存在");
            return;
        }
        if (!this._audio_bgm.playing) {
            console.log("重新播放bgm");
            this._audio_bgm.play();
        } else {
            console.log("bgm 播放中");
        }
    }
    /**
     * 设置BGM 音量
     */
    public setBgmVolume(volume: number = 0) {
        this.bgm_volume = volume;
        if (!this._audio_bgm) return;
        this._audio_bgm.volume = volume;
    }
    /**
     * 设置BGM 音量
     */
    public setSoundVolume(volume: number = 0) {
        this.sound_volume = volume;
        this._audio_list.forEach((value, key) => {
            if (value && value.playing && value != this._audio_bgm) {
                value.volume = this.sound_volume;
            }
        });
    }
}